/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.master.workerside;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.master.workerside.WorkerAbstraction;
import org.sosy_lab.verifiercloud.transportable.filecontent.FileContent;

public class WorkerCrashReportWriter {
    private static final String CRASH_REPORT_DIR_NAME = "workerCrashReports";
    private final SimpleDateFormat timeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private final Path reportDir;
    private final Logger logger;

    @Inject
    public WorkerCrashReportWriter(@Named(value="local-path") Path localPath, Logger logger) {
        this.logger = logger;
        this.reportDir = localPath.resolve(CRASH_REPORT_DIR_NAME);
    }

    public void write(WorkerAbstraction worker, FileContent crashReport) {
        this.logger.logf(Level.WARNING, "Received a crash report from %s.", worker);
        try {
            Files.createDirectories(this.reportDir, new FileAttribute[0]);
            Path file = this.reportDir.resolve(worker.toString() + "-" + this.timeFormat.format(new Date()));
            while (Files.exists(file, new LinkOption[0])) {
                file = this.reportDir.resolve(file.getFileName() + "_");
            }
            crashReport.writeToPath(file);
        }
        catch (IOException e) {
            this.logger.logf(Level.WARNING, e, "IOException while writing a worker crash report: %s", e.getMessage());
        }
    }
}

