/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.master.workerside.bootstrapping;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.util.Collection;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.master.workerside.bootstrapping.WorkerDispatcher;
import org.sosy_lab.verifiercloud.master.workerside.bootstrapping.WorkerStarter;
import org.sosy_lab.verifiercloud.transportable.units.time.TimeInterval;
import org.sosy_lab.verifiercloud.transportable.workerstart.WorkerStartInformation;

@Singleton
public class DefaultWorkerDispatcher
implements WorkerDispatcher {
    private static final Level INFORMATION_LOGGING_LEVEL = Level.FINER;
    private static final TimeInterval WORKER_DISPATCHING = TimeInterval.minutes(2L);
    static final TimeInterval MAX_WORKER_STARTUP_TIME = TimeInterval.minutes(1L);
    private static final TimeInterval HEARTBEAT_TIMER = TimeInterval.seconds(5L);
    private final Logger logger;
    private final WorkerStarter workerStarter;
    private final int workerToMasterPort;
    private final Map<WorkerStartInformation, Optional<Long>> availableHosts = Maps.newHashMap();
    private final Timer heartbeatTimer = new Timer(this.getClass().getSimpleName() + "-Timer", true);

    @Inject
    public DefaultWorkerDispatcher(WorkerStarter workerStarter, @Named(value="worker-to-master-port") Integer workerToMasterPort, Logger logger) {
        this.workerStarter = Preconditions.checkNotNull(workerStarter);
        this.workerToMasterPort = workerToMasterPort;
        this.logger = Preconditions.checkNotNull(logger);
    }

    @Override
    public synchronized void start(Collection<WorkerStartInformation> hosts) {
        for (WorkerStartInformation host : hosts) {
            WorkerStartInformation canonicalWorkerHost = host;
            if (!this.availableHosts.containsKey(canonicalWorkerHost)) {
                this.availableHosts.put(canonicalWorkerHost, Optional.of(0L));
                continue;
            }
            this.logger.logf(Level.WARNING, "Cannot add worker for host %s as duplicates are not allowed.", canonicalWorkerHost.getHostname());
        }
        if (this.logger.wouldLog(INFORMATION_LOGGING_LEVEL)) {
            ImmutableList<String> hostnames = FluentIterable.from(hosts).transform(new ExtractHostname()).toSortedList(Ordering.natural());
            this.logger.logf(INFORMATION_LOGGING_LEVEL, "Initial list of workers: %s", Joiner.on(' ').join(hostnames));
        }
        this.heartbeatTimer.schedule((TimerTask)new WorkerStartingTask(), 0L, HEARTBEAT_TIMER.toMilliseconds());
    }

    @Override
    public void stop() {
        this.heartbeatTimer.cancel();
    }

    @Override
    public synchronized ImmutableList<String> availableHosts() {
        return FluentIterable.from(this.availableHosts.keySet()).transform(new ExtractHostname()).toList();
    }

    @Override
    public synchronized boolean removeAvailableHost(String hostname) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(hostname));
        for (WorkerStartInformation worker : this.availableHosts.keySet()) {
            if (!worker.getHostname().equals(hostname)) continue;
            this.availableHosts.remove(worker);
            this.logger.logf(INFORMATION_LOGGING_LEVEL, "Removed worker %s from available workers.", hostname);
            return true;
        }
        this.logger.logf(INFORMATION_LOGGING_LEVEL, "Cannot remove worker %s, host unknown.", hostname);
        return false;
    }

    @Override
    public synchronized void addHost(WorkerStartInformation host) {
        if (!this.availableHosts.containsKey(host)) {
            this.availableHosts.put(host, Optional.of(0L));
            this.logger.logf(INFORMATION_LOGGING_LEVEL, "Added worker %s to available workers.", host.getHostname());
        } else {
            this.logger.logf(Level.WARNING, "Cannot add worker for host %s as it is already available. Doing nothing.", host);
        }
    }

    @Override
    public synchronized void setHostStatus(String workerId, boolean available) {
        Preconditions.checkNotNull(workerId);
        Optional<Object> associatedWorkerStartInfo = Optional.absent();
        for (WorkerStartInformation info : this.availableHosts.keySet()) {
            if (!info.getHostname().equals(workerId)) continue;
            associatedWorkerStartInfo = Optional.of(info);
        }
        if (associatedWorkerStartInfo.isPresent()) {
            Optional<Object> previousAttempt = available ? Optional.absent() : Optional.of(0L);
            this.availableHosts.put((WorkerStartInformation)associatedWorkerStartInfo.get(), (Optional<Long>)previousAttempt);
        }
    }

    private class WorkerStartingTask
    extends TimerTask {
        private WorkerStartingTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            DefaultWorkerDispatcher defaultWorkerDispatcher = DefaultWorkerDispatcher.this;
            synchronized (defaultWorkerDispatcher) {
                long currentTime = System.currentTimeMillis();
                for (Map.Entry entry : DefaultWorkerDispatcher.this.availableHosts.entrySet()) {
                    Optional previousAttempt = (Optional)entry.getValue();
                    if (!previousAttempt.isPresent() || currentTime - (Long)previousAttempt.get() < WORKER_DISPATCHING.toMilliseconds()) continue;
                    entry.setValue(Optional.of(currentTime));
                    String workerId = ((WorkerStartInformation)entry.getKey()).getHostname();
                    DefaultWorkerDispatcher.this.workerStarter.startWorker((WorkerStartInformation)entry.getKey(), workerId, DefaultWorkerDispatcher.this.workerToMasterPort);
                }
            }
        }
    }

    private static final class ExtractHostname
    implements Function<WorkerStartInformation, String> {
        private ExtractHostname() {
        }

        @Override
        public String apply(@Nonnull WorkerStartInformation input) {
            Preconditions.checkNotNull(input);
            return input.getHostname();
        }
    }
}

