/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.master.workerside.bootstrapping;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.net.UnknownHostException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import org.sosy_lab.verifiercloud.global.application.ApplicationService;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.global.statistics.StatisticsCollector;
import org.sosy_lab.verifiercloud.global.util.system.SystemInformationProvider;
import org.sosy_lab.verifiercloud.master.workerside.bootstrapping.StartWorkerRunnable;
import org.sosy_lab.verifiercloud.master.workerside.bootstrapping.WorkerStarter;
import org.sosy_lab.verifiercloud.transportable.workerstart.WorkerStartInformation;

public class DefaultWorkerStarter
implements WorkerStarter {
    private final ApplicationService master;
    private final Logger logger;
    private final SystemInformationProvider sysInfoProvider;
    private final StatisticsCollector statisticsCollector;
    private final ExecutorService workerStartup;
    private final boolean requirePingReachability;
    private final int maxRunResultFiles;

    @Inject
    public DefaultWorkerStarter(SystemInformationProvider sysInfoProvider, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, Logger logger, ApplicationService master, StatisticsCollector statisticsCollector, @Named(value="require-ping-reachability") Boolean requirePingReachability, @Named(value="max-run-result-files") Integer maxRunResultFiles) {
        this.master = master;
        this.sysInfoProvider = Preconditions.checkNotNull(sysInfoProvider);
        this.logger = Preconditions.checkNotNull(logger);
        this.statisticsCollector = Preconditions.checkNotNull(statisticsCollector);
        this.requirePingReachability = requirePingReachability;
        this.maxRunResultFiles = maxRunResultFiles;
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("WorkerStartup-%d").setUncaughtExceptionHandler(uncaughtExceptionHandler).build();
        this.workerStartup = Executors.newCachedThreadPool(threadFactory);
    }

    @Override
    public void startWorker(WorkerStartInformation workerStartInformation, String workerId, int masterToWorkerPort) {
        try {
            StartWorkerRunnable startWorkerRunnable = new StartWorkerRunnable(workerStartInformation, this.sysInfoProvider.getHostname(), workerId, this.maxRunResultFiles, true, masterToWorkerPort, this.requirePingReachability, this.statisticsCollector, this.logger);
            this.workerStartup.execute(startWorkerRunnable);
        }
        catch (UnknownHostException e) {
            this.logger.logf(Level.SEVERE, "Starting worker failed. Could not determine hostname (of master).", new Object[0]);
            this.master.stop();
        }
    }
}

