/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.master.workerside.bootstrapping;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.verifiercloud.master.workerside.bootstrapping.WorkerDispatcher;
import org.sosy_lab.verifiercloud.transportable.workerstart.WorkerStartInformation;

public abstract class WorkerDispatcherTestBase {
    private WorkerDispatcher workerDispatcher;

    public abstract WorkerDispatcher getInstance();

    @Before
    public void setUp() throws Exception {
        this.workerDispatcher = this.getInstance();
    }

    @After
    public void tearDown() throws Exception {
        this.workerDispatcher.stop();
    }

    @Test
    public void testAddOneHost() {
        this.workerDispatcher.start(Lists.newArrayList());
        String hostname = "host";
        WorkerStartInformation workerStartInfo = WorkerStartInformation.WorkerStartInformationBuilder.forHost(hostname).build();
        this.workerDispatcher.addHost(workerStartInfo);
        ImmutableList<String> hosts = this.workerDispatcher.availableHosts();
        HashSet<String> returnedHosts = Sets.newHashSet(hosts);
        HashSet<String> initialHosts = Sets.newHashSet(hostname);
        Assert.assertEquals(returnedHosts, initialHosts);
    }

    @Test
    public void testAddTwice() {
        this.workerDispatcher.start(Lists.newArrayList());
        String hostname = "host";
        WorkerStartInformation workerStartInfo1 = WorkerStartInformation.WorkerStartInformationBuilder.forHost(hostname).build();
        this.workerDispatcher.addHost(workerStartInfo1);
        WorkerStartInformation workerStartInfo2 = WorkerStartInformation.WorkerStartInformationBuilder.forHost(hostname).enableUserLoginCheck().build();
        this.workerDispatcher.addHost(workerStartInfo2);
        ImmutableList<String> hosts = this.workerDispatcher.availableHosts();
        HashSet<String> returnedHosts = Sets.newHashSet(hosts);
        HashSet<String> uniqueHosts = Sets.newHashSet(hostname);
        Assert.assertEquals(uniqueHosts, returnedHosts);
    }

    @Test
    public void testAddRemove() {
        this.workerDispatcher.start(Lists.newArrayList());
        String hostname = "host";
        WorkerStartInformation workerStartInfo = WorkerStartInformation.WorkerStartInformationBuilder.forHost(hostname).build();
        this.workerDispatcher.addHost(workerStartInfo);
        this.workerDispatcher.removeAvailableHost(hostname);
        ImmutableList<String> hosts = this.workerDispatcher.availableHosts();
        Assert.assertTrue((boolean)hosts.isEmpty());
    }

    @Test
    public void testStart() {
        String initialHost1 = "foo";
        String initialHost2 = "bar";
        ArrayList<WorkerStartInformation> initialWorkers = Lists.newArrayList(WorkerStartInformation.WorkerStartInformationBuilder.forHost(initialHost1).build(), WorkerStartInformation.WorkerStartInformationBuilder.forHost(initialHost2).build());
        this.workerDispatcher.start(initialWorkers);
        ImmutableList<String> hosts = this.workerDispatcher.availableHosts();
        HashSet<String> returnedHosts = Sets.newHashSet(hosts);
        HashSet<String> initialHosts = Sets.newHashSet(initialHost1, initialHost2);
        Assert.assertEquals(initialHosts, returnedHosts);
    }

    @Test
    public void testRemove() {
        String initialHost1 = "foo";
        String initialHost2 = "bar";
        ArrayList<WorkerStartInformation> initialWorkers = Lists.newArrayList(WorkerStartInformation.WorkerStartInformationBuilder.forHost(initialHost1).build(), WorkerStartInformation.WorkerStartInformationBuilder.forHost(initialHost2).build());
        this.workerDispatcher.start(initialWorkers);
        this.workerDispatcher.removeAvailableHost(initialHost2);
        ImmutableList<String> hosts = this.workerDispatcher.availableHosts();
        HashSet<String> returnedHosts = Sets.newHashSet(hosts);
        HashSet<String> expectedHosts = Sets.newHashSet(initialHost1);
        Assert.assertEquals(expectedHosts, returnedHosts);
    }

    @Test(expected=RuntimeException.class)
    public void testAddNull() {
        this.workerDispatcher.start(Lists.newArrayList());
        this.workerDispatcher.addHost(null);
    }
}

