/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.master.workerside.functional_idioms;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;

public class EnoughAvailablMemoryOnNodes
implements Predicate<Set<Integer>> {
    private final MemoryUnit memoryRequirements;
    private final Map<Integer, MemoryUnit> socketToAvailableMemory;

    public EnoughAvailablMemoryOnNodes(MemoryUnit memoryRequirements, Map<Integer, MemoryUnit> availableNumaMemory) {
        this.memoryRequirements = Preconditions.checkNotNull(memoryRequirements);
        this.socketToAvailableMemory = Preconditions.checkNotNull(availableNumaMemory);
    }

    @Override
    public boolean apply(Set<Integer> nodes) {
        MemoryUnit availableMemory = MemoryUnit.zero();
        for (int node : nodes) {
            if (!this.socketToAvailableMemory.containsKey(node)) continue;
            MemoryUnit availableMemoryOnSocket = this.socketToAvailableMemory.get(node);
            availableMemory = MemoryUnit.sum(availableMemory, availableMemoryOnSocket);
        }
        return availableMemory.compareTo(this.memoryRequirements) >= 0;
    }
}

