/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.master.workerside.functional_idioms;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.Map;
import java.util.Set;

public class EnoughAvailablProcessorsOnNodes
implements Predicate<Set<Integer>> {
    private final int processorRequirements;
    private final Map<Integer, Integer> socketToUsabelProcessorCount;

    public EnoughAvailablProcessorsOnNodes(int processorRequirements, Map<Integer, Integer> socketToUsabelProcessorCount) {
        this.processorRequirements = Preconditions.checkNotNull(processorRequirements);
        this.socketToUsabelProcessorCount = Preconditions.checkNotNull(socketToUsabelProcessorCount);
    }

    @Override
    public boolean apply(Set<Integer> nodes) {
        int usableProcessors = 0;
        for (int node : nodes) {
            usableProcessors += this.socketToUsabelProcessorCount.get(node).intValue();
        }
        return usableProcessors >= this.processorRequirements;
    }
}

