/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.transportable.collections;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.hash.HashCode;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sosy_lab.verifiercloud.transportable.collections.RunCollection;
import org.sosy_lab.verifiercloud.transportable.collections.SchedulingPriority;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.FileAtRelativePath;
import org.sosy_lab.verifiercloud.transportable.run.Run;
import org.sosy_lab.verifiercloud.transportable.run.constraints.requirements.MinimalRequirements;
import org.sosy_lab.verifiercloud.transportable.run.constraints.requirements.Requirements;

@Immutable
public class DefaultRunCollection
implements RunCollection {
    private static final long serialVersionUID = 3214782126742482444L;
    private final String id;
    private final ImmutableList<Run> runs;
    private final Requirements requirements;
    private final SchedulingPriority initialPriority;
    private final ImmutableSet<HashCode> allRequiredFileHashes;
    private final String runCollectionName;
    @Nullable
    private final String userName;

    public DefaultRunCollection(List<Run> runs, SchedulingPriority initialPriority, Requirements requirements, String name, Optional<String> userName) {
        Preconditions.checkArgument(!runs.isEmpty());
        this.runs = ImmutableList.copyOf(runs);
        this.allRequiredFileHashes = ImmutableSet.copyOf(this.calculateAllRequiredFileHashes());
        this.initialPriority = Preconditions.checkNotNull(initialPriority);
        this.requirements = Preconditions.checkNotNull(requirements);
        Preconditions.checkNotNull(name);
        Preconditions.checkArgument(!name.contains("\n"), "RunCollection name must not contain newline: '%s'", name);
        this.runCollectionName = name;
        this.userName = userName.orNull();
        this.id = UUID.randomUUID().toString();
    }

    @Override
    public ImmutableList<Run> getRuns() {
        return this.runs;
    }

    @Override
    public Requirements getRequirements() {
        return this.requirements;
    }

    @Override
    public String getName() {
        return this.runCollectionName;
    }

    @Override
    public Optional<String> getUserName() {
        return Optional.fromNullable(this.userName);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public SchedulingPriority getPriority() {
        return this.initialPriority;
    }

    @Override
    public ImmutableSet<HashCode> getAllRequiredFileHashes() {
        return this.allRequiredFileHashes;
    }

    private Collection<HashCode> calculateAllRequiredFileHashes() {
        HashSet<HashCode> fileHashes = Sets.newHashSet();
        for (Run run : this.getRuns()) {
            for (FileAtRelativePath fileAtRelativePath : run.getFileHierarchy()) {
                fileHashes.add(fileAtRelativePath.getFileHash());
            }
        }
        return fileHashes;
    }

    public String toString() {
        return "RunCollection[" + this.id + "]";
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DefaultRunCollection)) {
            return false;
        }
        DefaultRunCollection that = (DefaultRunCollection)other;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public static DefaultRunCollectionBuilder forRuns(Collection<Run> runs) {
        return new DefaultRunCollectionBuilder(runs);
    }

    public static class DefaultRunCollectionBuilder {
        private final ImmutableList<Run> runs;
        private SchedulingPriority initialPriority = SchedulingPriority.IDLE;
        private Requirements requirements = MinimalRequirements.getInstance();
        private String name = "";
        private Optional<String> userName = Optional.absent();

        private DefaultRunCollectionBuilder(Collection<Run> runs) {
            this.runs = ImmutableList.copyOf(runs);
        }

        public DefaultRunCollectionBuilder setInitialPriority(SchedulingPriority initialPriority) {
            this.initialPriority = Preconditions.checkNotNull(initialPriority);
            return this;
        }

        public DefaultRunCollectionBuilder setRequirements(Requirements requirements) {
            this.requirements = Preconditions.checkNotNull(requirements);
            return this;
        }

        public DefaultRunCollectionBuilder setName(String name) {
            this.name = Preconditions.checkNotNull(name);
            return this;
        }

        public DefaultRunCollectionBuilder setUserName(Optional<String> userName) {
            this.userName = Preconditions.checkNotNull(userName);
            return this;
        }

        public RunCollection build() {
            return new DefaultRunCollection(this.runs, this.initialPriority, this.requirements, this.name, this.userName);
        }
    }
}

