/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.transportable.commands.master_to_client;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.hash.HashCode;
import java.util.Collection;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.sosy_lab.verifiercloud.client.network.ClientAPI;
import org.sosy_lab.verifiercloud.client.network.MasterAbstraction;
import org.sosy_lab.verifiercloud.transportable.commands.master_to_client.MasterToClientCommand;

@Immutable
public class RequestAndDeclineFilesCommand
implements MasterToClientCommand {
    private static final long serialVersionUID = 4L;
    private final ImmutableSet<HashCode> requestedFiles;
    private final ImmutableSet<HashCode> declinedFiles;

    public RequestAndDeclineFilesCommand(Collection<HashCode> requestedFiles, Collection<HashCode> declinedFiles) {
        Preconditions.checkNotNull(requestedFiles);
        Preconditions.checkNotNull(declinedFiles);
        Preconditions.checkArgument(requestedFiles.size() > 0 || declinedFiles.size() > 0);
        this.requestedFiles = ImmutableSet.copyOf(requestedFiles);
        this.declinedFiles = ImmutableSet.copyOf(declinedFiles);
        Preconditions.checkArgument(this.isEmptyIntersection(this.requestedFiles, this.declinedFiles));
    }

    private <T> boolean isEmptyIntersection(Set<T> set1, Set<T> set2) {
        return Sets.intersection(set1, set2).isEmpty();
    }

    @Override
    public void acceptAPI(MasterAbstraction sender, ClientAPI api) {
        for (HashCode fileHash : this.declinedFiles) {
            api.declineFile(fileHash);
        }
        for (HashCode fileHash : this.requestedFiles) {
            api.requestFile(fileHash);
        }
    }
}

