/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.transportable.commands.master_to_client;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.UUID;
import javax.annotation.concurrent.Immutable;
import org.sosy_lab.verifiercloud.client.network.ClientAPI;
import org.sosy_lab.verifiercloud.client.network.MasterAbstraction;
import org.sosy_lab.verifiercloud.transportable.commands.master_to_client.MasterToClientCommand;

@Immutable
public class RequestFailedCommand
implements MasterToClientCommand {
    private static final long serialVersionUID = -4359244149289653038L;
    private final String reason;
    private final UUID requestID;

    public RequestFailedCommand(String reason, UUID requestID) {
        this.reason = reason;
        this.requestID = Preconditions.checkNotNull(requestID);
        Preconditions.checkArgument(!Strings.isNullOrEmpty(reason));
    }

    @Override
    public void acceptAPI(MasterAbstraction sender, ClientAPI api) {
        api.requestFailed(this.reason, this.requestID);
    }
}

