/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.transportable.commands.master_to_worker;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.sosy_lab.verifiercloud.transportable.commands.master_to_worker.MasterToWorkerCommand;
import org.sosy_lab.verifiercloud.transportable.info.processors.Processor;
import org.sosy_lab.verifiercloud.transportable.run.Run;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;
import org.sosy_lab.verifiercloud.worker.network.MasterAbstraction;
import org.sosy_lab.verifiercloud.worker.network.WorkerAPI;

@Immutable
public class AssignRunCommand
implements MasterToWorkerCommand {
    private static final long serialVersionUID = 8656705249116819908L;
    private final Run run;
    private final String runCollectionId;
    private final ImmutableSet<Processor> processors;
    private final ImmutableMap<Integer, MemoryUnit> memoryLimitation;

    public AssignRunCommand(Run run, String runCollectionId, Set<Processor> processors, Map<Integer, MemoryUnit> memoryLimit) {
        this.run = Preconditions.checkNotNull(run);
        this.runCollectionId = runCollectionId;
        Preconditions.checkArgument(!processors.isEmpty());
        this.processors = ImmutableSet.copyOf(processors);
        Preconditions.checkArgument(!memoryLimit.isEmpty());
        this.memoryLimitation = ImmutableMap.copyOf(memoryLimit);
    }

    @Override
    public void acceptAPI(MasterAbstraction sender, WorkerAPI api) {
        api.assignRun(this.run, this.runCollectionId, this.processors, this.memoryLimitation);
    }
}

