/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.transportable.commands.worker_to_master;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.Immutable;
import org.sosy_lab.verifiercloud.master.workerside.WorkerAbstraction;
import org.sosy_lab.verifiercloud.master.workerside.WorkerToMasterAPI;
import org.sosy_lab.verifiercloud.transportable.commands.worker_to_master.WorkerToMasterCommand;
import org.sosy_lab.verifiercloud.transportable.info.worker.ExecutorState;
import org.sosy_lab.verifiercloud.transportable.info.worker.WorkerRuntimeInformation;
import org.sosy_lab.verifiercloud.transportable.info.worker.constant.HostInformation;

@Immutable
public class WorkerStartedCommand
implements WorkerToMasterCommand {
    private static final long serialVersionUID = 806684740960053335L;
    private final HostInformation hostInfo;
    private final ExecutorState executorState;
    private final WorkerRuntimeInformation workerRuntimeInformation;
    private final Optional<String> workerId;

    public WorkerStartedCommand(HostInformation info, ExecutorState processorState, Optional<String> workerId, WorkerRuntimeInformation workerRuntimeInformation) {
        this.hostInfo = Preconditions.checkNotNull(info);
        this.executorState = Preconditions.checkNotNull(processorState);
        this.workerRuntimeInformation = Preconditions.checkNotNull(workerRuntimeInformation);
        this.workerId = Preconditions.checkNotNull(workerId);
    }

    @Override
    public void acceptAPI(WorkerAbstraction sender, WorkerToMasterAPI api) {
        api.workerStarted(sender, this.hostInfo, this.workerId, this.executorState, this.workerRuntimeInformation);
    }
}

