/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.transportable.file_hierarchy;

import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import javax.annotation.concurrent.Immutable;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.FileAtRelativePath;

@Immutable
public abstract class AbstractFileAtRelativePath
implements FileAtRelativePath {
    private static final long serialVersionUID = 1252485871331912978L;
    private final HashCode fileHash;
    private final boolean isExecutable;

    public AbstractFileAtRelativePath(HashCode fileHash, boolean isExecutable) {
        this.fileHash = Preconditions.checkNotNull(fileHash);
        this.isExecutable = isExecutable;
    }

    @Override
    public HashCode getFileHash() {
        return this.fileHash;
    }

    @Override
    public boolean isExecutable() {
        return this.isExecutable;
    }

    public final int hashCode() {
        return this.fileHash.hashCode();
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FileAtRelativePath)) {
            return false;
        }
        FileAtRelativePath that = (FileAtRelativePath)other;
        return this.fileHash.equals(that.getFileHash()) && this.getRelativePathString().equals(that.getRelativePathString()) && this.isExecutable == that.isExecutable();
    }

    public String toString() {
        return String.format("(%s,%s)", this.getRelativePathString(), this.getFileHash().toString());
    }
}

