/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.transportable.file_hierarchy;

import com.google.common.base.Charsets;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import org.junit.Assert;
import org.junit.Test;
import org.sosy_lab.verifiercloud.global.util.HashUtils;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.FileAtRelativePath;

public abstract class FileAtRelativePathTestBase {
    @Test
    public void testEquality() {
        String filePath = "relative/path/to/file";
        Hasher hasher = Hashing.sha1().newHasher().putLong(42L);
        HashCode hashCode1 = hasher.hash();
        FileAtRelativePath fileAtRelativePath1 = this.getFileAtRelativePath(hashCode1, "relative/path/to/file");
        hasher = Hashing.sha1().newHasher().putLong(42L);
        HashCode hashCode2 = hasher.hash();
        FileAtRelativePath fileAtRelativePath2 = this.getFileAtRelativePath(hashCode2, "relative/path/to/file");
        Assert.assertEquals((Object)fileAtRelativePath1, (Object)fileAtRelativePath2);
    }

    @Test
    public void testHiddenEquality() throws Exception {
        HashCode fileHash = this.getFileHashCode();
        FileAtRelativePath fileAtPath1 = this.getFileAtRelativePath(fileHash, "foo/bar");
        FileAtRelativePath fileAtPath2 = this.getFileAtRelativePath(fileHash, "foo/unnecessary_folder/../bar");
        Assert.assertEquals((Object)fileAtPath1, (Object)fileAtPath2);
    }

    @Test
    public void testHash() {
        String filePath = "relative/path/to/file";
        byte[] fileContent = "some content".getBytes(Charsets.UTF_8);
        HashCode fileHash1 = HashUtils.getSha1Hash(fileContent);
        FileAtRelativePath fileAtRelativePath1 = this.getFileAtRelativePath(fileHash1, "relative/path/to/file");
        HashCode fileHash2 = HashUtils.getSha1Hash(fileContent);
        FileAtRelativePath fileAtRelativePath2 = this.getFileAtRelativePath(fileHash2, "relative/path/to/file");
        Assert.assertEquals((long)fileAtRelativePath1.hashCode(), (long)fileAtRelativePath2.hashCode());
    }

    @Test(expected=RuntimeException.class)
    public void testExceptionAbsolutePath() {
        HashCode fileHash = this.getFileHashCode();
        this.getFileAtRelativePath(fileHash, "/tmp/something");
    }

    @Test(expected=RuntimeException.class)
    public void testExceptionSuperPath() throws Exception {
        HashCode fileHash = this.getFileHashCode();
        this.getFileAtRelativePath(fileHash, "../foo");
    }

    @Test
    public void testPathSimplificationCurrentDir() {
        FileAtRelativePath farp = this.getFileAtRelativePath(this.getFileHashCode(), "./dir/file");
        String returnedRelativePath = farp.getRelativePathString();
        Assert.assertEquals((Object)"dir/file", (Object)returnedRelativePath);
    }

    @Test
    public void testPathSimplificationParentDir() {
        FileAtRelativePath farp = this.getFileAtRelativePath(this.getFileHashCode(), "dir/to_remove/../file");
        String returnedRelativePath = farp.getRelativePathString();
        Assert.assertEquals((Object)"dir/file", (Object)returnedRelativePath);
    }

    @Test(expected=RuntimeException.class)
    public void testExceptionSuperPathHidden() throws Exception {
        HashCode fileHash = this.getFileHashCode();
        this.getFileAtRelativePath(fileHash, "foo/../../bar");
    }

    private HashCode getFileHashCode() {
        HashCode fileHash = HashUtils.getSha1Hash("content".getBytes(Charsets.UTF_8));
        return fileHash;
    }

    @Test(expected=RuntimeException.class)
    public void testExceptionEmptyPath() {
        this.getFileAtRelativePath(this.getFileHashCode(), "");
    }

    @Test(expected=RuntimeException.class)
    public void testExceptionEmptyPathCurrentFolder() {
        this.getFileAtRelativePath(this.getFileHashCode(), ".");
    }

    @Test(expected=RuntimeException.class)
    public void testExceptionElaborateEmptyPath() {
        this.getFileAtRelativePath(this.getFileHashCode(), "./.");
    }

    protected abstract FileAtRelativePath getFileAtRelativePath(HashCode var1, String var2);
}

