/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.transportable.file_hierarchy;

import com.google.common.base.Charsets;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.hash.HashCode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.sosy_lab.verifiercloud.global.util.HashUtils;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.FileAtRelativePath;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.FileHierarchy;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.string_based.DefaultFileAtRelativePath;

public abstract class FileHierarchyTestBase {
    private static int hashCounter = 0;

    @Test(expected=NullPointerException.class)
    public void listOfFilesNull() {
        this.getFileHierarchy(null);
    }

    @Test
    public void testEquals() {
        ArrayList<FileAtRelativePath> files = Lists.newArrayList();
        files.add(new DefaultFileAtRelativePath(this.createHashCode(), "foo"));
        files.add(new DefaultFileAtRelativePath(this.createHashCode(), "bar"));
        DefaultFileAtRelativePath file = new DefaultFileAtRelativePath(this.createHashCode(), "test");
        FileHierarchy fileHierarchy1 = this.getFileHierarchy(files, file);
        FileHierarchy fileHierarchy2 = this.getFileHierarchy(files, file);
        Assert.assertEquals((Object)fileHierarchy1, (Object)fileHierarchy2);
    }

    @Test
    public void testSerialization() throws IOException, ClassNotFoundException {
        DefaultFileAtRelativePath fileAtRelativePath = new DefaultFileAtRelativePath(this.createHashCode(), "path");
        ArrayList<FileAtRelativePath> files = Lists.newArrayList(fileAtRelativePath);
        DefaultFileAtRelativePath file = new DefaultFileAtRelativePath(this.createHashCode(), "test");
        files.add(new DefaultFileAtRelativePath(this.createHashCode(), "foo/foo"));
        files.add(new DefaultFileAtRelativePath(this.createHashCode(), "bar/foo"));
        FileHierarchy fileHierarchy = this.getFileHierarchy(files, file);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(out);
        oos.writeObject(fileHierarchy);
        oos.close();
        byte[] pickled = out.toByteArray();
        ByteArrayInputStream in = new ByteArrayInputStream(pickled);
        ObjectInputStream ois = new ObjectInputStream(in);
        Object o = ois.readObject();
        FileHierarchy deserializedFileHierarchy = (FileHierarchy)o;
        Assert.assertEquals((Object)fileHierarchy, (Object)deserializedFileHierarchy);
    }

    @Test(expected=RuntimeException.class)
    public void testTwoFileHashesWithEqualPath() {
        DefaultFileAtRelativePath fileAtRelativePath1 = new DefaultFileAtRelativePath(this.createHashCode(), "path");
        DefaultFileAtRelativePath fileAtRelativePath2 = new DefaultFileAtRelativePath(this.createHashCode(), "path");
        ArrayList<FileAtRelativePath> files = Lists.newArrayList(fileAtRelativePath1);
        this.getFileHierarchy(files, fileAtRelativePath2);
    }

    @Test(expected=RuntimeException.class)
    public void testImmutabilityIterator() throws Exception {
        DefaultFileAtRelativePath fileAtRelativePath1 = new DefaultFileAtRelativePath(this.createHashCode(), "path");
        DefaultFileAtRelativePath fileAtRelativePath2 = new DefaultFileAtRelativePath(this.createHashCode(), "path2");
        ArrayList<FileAtRelativePath> files = Lists.newArrayList(fileAtRelativePath1);
        FileHierarchy fileHierarchy = this.getFileHierarchy(files, fileAtRelativePath2);
        UnmodifiableIterator<FileAtRelativePath> iterator = fileHierarchy.iterator();
        iterator.remove();
    }

    @Test
    public void testCorrectNumberOfFiles() throws Exception {
        ArrayList<FileAtRelativePath> files = Lists.newArrayList();
        for (int i = 0; i < 50000; ++i) {
            DefaultFileAtRelativePath file = new DefaultFileAtRelativePath(this.createHashCode(), this.createHashCode().toString());
            files.add(file);
        }
        FileHierarchy fileHierarchy = this.getFileHierarchy(files, new DefaultFileAtRelativePath(this.createHashCode(), this.createHashCode().toString()));
        Assert.assertEquals((long)50001L, (long)FluentIterable.from(fileHierarchy).size());
    }

    @Test(expected=RuntimeException.class)
    public void testRunWith50000FilesCollisionDirAndFile() {
        String commonPathPrefix = "foo/bar";
        ArrayList<FileAtRelativePath> files = Lists.newArrayList();
        for (int i = 0; i < 50000; ++i) {
            HashCode fileHash = this.createHashCode();
            String path = String.format("%s/%d/%s", commonPathPrefix, i % 133, fileHash.toString());
            DefaultFileAtRelativePath farp = new DefaultFileAtRelativePath(fileHash, path);
            files.add(farp);
        }
        DefaultFileAtRelativePath collisionPath = new DefaultFileAtRelativePath(this.createHashCode(), commonPathPrefix + "/12");
        this.getFileHierarchy(files, collisionPath);
    }

    protected HashCode createHashCode() {
        return HashUtils.getSha1Hash(String.valueOf(hashCounter++).getBytes(Charsets.UTF_8));
    }

    protected abstract FileHierarchy getFileHierarchy(Collection<FileAtRelativePath> var1, FileAtRelativePath var2);

    private FileHierarchy getFileHierarchy(FileAtRelativePath arguementFile) {
        return this.getFileHierarchy(new ArrayList<FileAtRelativePath>(), arguementFile);
    }
}

