/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.transportable.file_hierarchy.string_based;

import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import javax.annotation.concurrent.Immutable;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.AbstractFileAtRelativePath;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.RelativePath;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.string_based.StringRelativePath;

@Immutable
public class DefaultFileAtRelativePath
extends AbstractFileAtRelativePath {
    private static final long serialVersionUID = -8156495798687261578L;
    private final RelativePath relativePath;

    public DefaultFileAtRelativePath(HashCode fileHash, String relativePath) {
        super(fileHash, true);
        Preconditions.checkNotNull(relativePath);
        this.relativePath = StringRelativePath.from(relativePath);
        Preconditions.checkArgument(this.relativePath.isChild(), "%s relies on the parent directory.", relativePath);
        Preconditions.checkArgument(!this.relativePath.isWorkingDirectory(), "%s is the working directory (which is by definition a directory).", relativePath);
    }

    @Override
    public String getRelativePathString() {
        return this.relativePath.getRelativePath();
    }

    @Override
    public RelativePath getRelativePath() {
        return this.relativePath;
    }
}

