/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.transportable.file_hierarchy.string_based;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import javax.annotation.concurrent.Immutable;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.FileAtRelativePath;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.FileHierarchy;

@Immutable
public class DefaultFileHierarchy
implements FileHierarchy {
    private static final long serialVersionUID = -6316997863411101741L;
    private final ImmutableList<FileAtRelativePath> files;

    public DefaultFileHierarchy(Collection<FileAtRelativePath> files) {
        Preconditions.checkNotNull(files);
        this.checkPathUniqueness(files);
        this.files = ImmutableList.copyOf(files);
    }

    private void checkPathUniqueness(Iterable<FileAtRelativePath> files) {
        HashMap<String, Boolean> collisionMap = Maps.newHashMap();
        for (FileAtRelativePath fileAtRelativePath : files) {
            String pathRepresentation = fileAtRelativePath.getRelativePathString();
            Boolean previousValue = collisionMap.put(pathRepresentation, true);
            if (previousValue != null) {
                throw new RuntimeException("Path must be unique. " + pathRepresentation + " is given twice.");
            }
            boolean unknownPath = true;
            int lastPos = pathRepresentation.lastIndexOf(File.separatorChar);
            while (unknownPath && lastPos != -1) {
                previousValue = collisionMap.put(pathRepresentation = pathRepresentation.substring(0, lastPos), false);
                if (previousValue != null) {
                    if (previousValue.booleanValue()) {
                        String collisionDescription = String.format("A path is used both as a directory and as a file: %s", pathRepresentation);
                        throw new RuntimeException(collisionDescription);
                    }
                    unknownPath = false;
                }
                lastPos = pathRepresentation.lastIndexOf(File.separatorChar);
            }
        }
    }

    @Override
    public UnmodifiableIterator<FileAtRelativePath> iterator() {
        return this.files.iterator();
    }

    @Override
    public int size() {
        return this.files.size();
    }

    public int hashCode() {
        return this.files.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FileHierarchy)) {
            return false;
        }
        FileHierarchy other = (FileHierarchy)obj;
        if (this.hashCode() == other.hashCode()) {
            ArrayList thisFiles = Lists.newArrayList(this.iterator());
            ArrayList<FileAtRelativePath> thatFiles = Lists.newArrayList(other.iterator());
            Comparator<FileAtRelativePath> comperator = new Comparator<FileAtRelativePath>(){

                @Override
                public int compare(FileAtRelativePath o1, FileAtRelativePath o2) {
                    return o1.getRelativePathString().compareTo(o1.getRelativePathString());
                }
            };
            Collections.sort(thisFiles, comperator);
            Collections.sort(thatFiles, comperator);
            return thisFiles.equals(thatFiles);
        }
        return false;
    }
}

