/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.transportable.file_hierarchy.string_based;

import com.google.common.base.Preconditions;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.concurrent.Immutable;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.RelativePath;

@Immutable
public final class StringRelativePath
implements RelativePath {
    private static final long serialVersionUID = -2938852138565426897L;
    private static final Path SUPER_DIRECTORY = Paths.get("..", new String[0]);
    private static final Path EMPTY_PATH = Paths.get("", new String[0]);
    private final String relativePath;

    public static RelativePath from(String relativePath) {
        Preconditions.checkNotNull(relativePath);
        return new StringRelativePath(Paths.get(relativePath, new String[0]));
    }

    public static RelativePath from(Path relativePath) {
        return new StringRelativePath(relativePath);
    }

    private StringRelativePath(Path path) {
        Preconditions.checkNotNull(path);
        Preconditions.checkArgument(!path.isAbsolute(), "%s is not a relative path.", path);
        Preconditions.checkArgument(!path.equals(EMPTY_PATH), "Given path is empty.");
        String normalizedPath = path.normalize().toString();
        this.relativePath = normalizedPath.isEmpty() ? "." : normalizedPath;
    }

    @Override
    public boolean isWorkingDirectory() {
        return this.relativePath.equals(".");
    }

    @Override
    public boolean isChild() {
        return !Paths.get(this.relativePath, new String[0]).startsWith(SUPER_DIRECTORY);
    }

    @Override
    public String getRelativePath() {
        return this.relativePath;
    }

    @Override
    public String toString() {
        return this.relativePath;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RelativePath)) {
            return false;
        }
        RelativePath that = (RelativePath)other;
        return that.getRelativePath().equals(this.getRelativePath());
    }

    @Override
    public int hashCode() {
        return this.relativePath.hashCode();
    }
}

