/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.transportable.file_hierarchy.tree_based;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.PeekingIterator;
import com.google.common.collect.Sets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.FileAtRelativePath;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.FileHierarchy;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.tree_based.TreeFileAtRelativePath;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.tree_based.TreeFileHierarchy;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.tree_based.TreeRelativePath;

public class TreeFileHierarchyBuilder {
    public static final String ROOT_PREFIX = ".";
    private ForwardTree forwardTree = new ForwardTree();
    private Set<TreeFileAtRelativePath> programFiles = Sets.newHashSet();

    public int size() {
        return this.programFiles.size();
    }

    public synchronized void addProgramFiles(FileAtRelativePath file) {
        Preconditions.checkNotNull(file);
        if (!this.programFiles.contains(file)) {
            TreeFileAtRelativePath treeFile = this.forwardTree.getTreeFileAtRelativePath(file);
            this.programFiles.add(treeFile);
        }
    }

    public synchronized void addProgramFiles(Iterable<FileAtRelativePath> files) {
        Preconditions.checkNotNull(files);
        for (FileAtRelativePath fileAtRelativePath : files) {
            this.addProgramFiles(fileAtRelativePath);
        }
    }

    public synchronized FileHierarchy buildForAgrumentFile(FileAtRelativePath argumentFile) {
        return this.buildForAgrumentFiles(Lists.newArrayList(argumentFile));
    }

    public synchronized FileHierarchy buildForAgrumentFiles(Iterable<FileAtRelativePath> argumentFiles) {
        ArrayList<TreeFileAtRelativePath> builtFiles = Lists.newArrayList(this.programFiles);
        for (FileAtRelativePath argumentFile : argumentFiles) {
            if (this.programFiles.contains(argumentFile)) continue;
            TreeFileAtRelativePath argumentTreeFile = this.forwardTree.getTreeFileAtRelativePath(argumentFile);
            builtFiles.add(argumentTreeFile);
        }
        return new TreeFileHierarchy(builtFiles);
    }

    public synchronized FileHierarchy build() {
        return new TreeFileHierarchy(this.programFiles);
    }

    private class ForwardTree {
        private final ForwardRelativePath root = new ForwardRelativePath();

        private ForwardTree() {
        }

        private TreeFileAtRelativePath getTreeFileAtRelativePath(FileAtRelativePath file) {
            Iterator<Path> simplePathElemIterator = Iterators.concat(Paths.get(TreeFileHierarchyBuilder.ROOT_PREFIX, new String[0]).iterator(), Paths.get(file.getRelativePathString(), new String[0]).iterator());
            PeekingIterator<Path> nameElements = Iterators.peekingIterator(simplePathElemIterator);
            return this.root.getTreeFileAtRelativePath(file, nameElements);
        }

        private class ForwardRelativePath {
            private final TreeRelativePath path;
            private final Map<String, ForwardRelativePath> children = Maps.newHashMap();
            private final Set<TreeFileAtRelativePath> childFiles = Sets.newHashSet();

            private ForwardRelativePath() {
                this.path = TreeRelativePath.createRoot();
            }

            private ForwardRelativePath(Iterator<Path> nameElements, FileAtRelativePath file, ForwardRelativePath parent) {
                Preconditions.checkNotNull(nameElements);
                Preconditions.checkNotNull(file);
                Preconditions.checkNotNull(parent);
                Preconditions.checkArgument(nameElements.hasNext());
                this.path = new TreeRelativePath(nameElements.next().toString(), parent.getPath());
                if (nameElements.hasNext()) {
                    ForwardRelativePath newChildPath = new ForwardRelativePath(nameElements, file, this);
                    this.addChildPath(newChildPath.getPathElement(), newChildPath);
                } else {
                    this.createAddAndReturnChildFile(file);
                }
            }

            private TreeFileAtRelativePath getTreeFileAtRelativePath(FileAtRelativePath file, PeekingIterator<Path> pathElements) {
                TreeFileAtRelativePath result;
                Preconditions.checkArgument(pathElements.hasNext());
                String currentPathElement = pathElements.next().toString();
                Preconditions.checkArgument(currentPathElement.equals(this.path.getPathElement()));
                if (pathElements.hasNext()) {
                    String nextPathElement = pathElements.peek().toString();
                    Preconditions.checkArgument(pathElements.hasNext());
                    if (this.children.containsKey(nextPathElement)) {
                        ForwardRelativePath childPath = this.children.get(nextPathElement);
                        result = childPath.getTreeFileAtRelativePath(file, pathElements);
                    } else {
                        Path[] furtherPathElements = Iterators.toArray(pathElements, Path.class);
                        PeekingIterator<Path> newPathElements1 = Iterators.peekingIterator(Iterators.forArray(furtherPathElements));
                        PeekingIterator<Path> newPathElements2 = Iterators.peekingIterator(Iterators.forArray(furtherPathElements));
                        ForwardRelativePath newChildPath = new ForwardRelativePath(newPathElements1, file, this);
                        this.addChildPath(nextPathElement, newChildPath);
                        result = newChildPath.getTreeFileAtRelativePath(file, newPathElements2);
                    }
                } else {
                    for (ForwardRelativePath childPath : this.children.values()) {
                        childPath.checkNoBuildFileInSubtree();
                    }
                    if (this.childFiles.contains(file)) {
                        for (TreeFileAtRelativePath tmpFile : this.childFiles) {
                            if (tmpFile.equals(file)) {
                                result = tmpFile;
                                continue;
                            }
                            Preconditions.checkArgument(!TreeFileHierarchyBuilder.this.programFiles.contains(tmpFile));
                        }
                        result = this.getChildFile(file);
                    } else {
                        for (TreeFileAtRelativePath tmpPath : this.childFiles) {
                            Preconditions.checkArgument(!TreeFileHierarchyBuilder.this.programFiles.contains(tmpPath));
                        }
                        result = this.createAddAndReturnChildFile(file);
                    }
                }
                return result;
            }

            private void checkNoBuildFileInSubtree() throws IllegalArgumentException {
                for (TreeFileAtRelativePath childFile : this.childFiles) {
                    Preconditions.checkArgument(!TreeFileHierarchyBuilder.this.programFiles.contains(childFile));
                }
                for (ForwardRelativePath childPath : this.children.values()) {
                    childPath.checkNoBuildFileInSubtree();
                }
            }

            private TreeFileAtRelativePath getChildFile(FileAtRelativePath file) {
                for (TreeFileAtRelativePath tempFile : this.childFiles) {
                    if (!tempFile.equals(file)) continue;
                    return tempFile;
                }
                throw new IllegalArgumentException(String.format("ForwardPath %s does not contain a direct child %s", this.path.getPathElement(), file));
            }

            private TreeRelativePath getPath() {
                return this.path;
            }

            private String getPathElement() {
                return this.path.getPathElement();
            }

            private void addChildPath(String nextPathElement, ForwardRelativePath newChildPath) {
                boolean equals = newChildPath.getPathElement().equals(nextPathElement);
                Preconditions.checkArgument(equals, String.format("%s, %s", newChildPath.getPathElement(), nextPathElement));
                Preconditions.checkArgument(!this.children.containsKey(nextPathElement));
                this.children.put(nextPathElement, newChildPath);
            }

            private TreeFileAtRelativePath createAddAndReturnChildFile(FileAtRelativePath newChildFile) {
                TreeFileAtRelativePath newChildTeeFile = new TreeFileAtRelativePath(newChildFile.getFileHash(), this.path, newChildFile.isExecutable());
                Preconditions.checkArgument(!this.childFiles.contains(newChildTeeFile));
                this.childFiles.add(newChildTeeFile);
                return newChildTeeFile;
            }
        }
    }
}

