/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.transportable.file_hierarchy.tree_based;

import com.google.common.base.Preconditions;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.RelativePath;

@Immutable
public class TreeRelativePath
implements RelativePath {
    private static final long serialVersionUID = 2L;
    private static final Path SUPER_DIRECTORY = Paths.get("..", new String[0]);
    private final String nameElement;
    @Nullable
    private final TreeRelativePath optionalParent;
    @Nullable
    private volatile transient String pathBuffer;

    public static TreeRelativePath createRoot() {
        return new TreeRelativePath(".");
    }

    private TreeRelativePath(String nameElement) {
        this.nameElement = Preconditions.checkNotNull(nameElement);
        Preconditions.checkArgument(nameElement.equals("."));
        this.optionalParent = null;
    }

    public TreeRelativePath(String nameElement, TreeRelativePath relativPath) {
        this.nameElement = Preconditions.checkNotNull(nameElement);
        this.optionalParent = Preconditions.checkNotNull(relativPath);
    }

    @Override
    public String getRelativePath() {
        if (this.pathBuffer == null) {
            StringBuilder stringBuilder = this.getRelativePath(new StringBuilder());
            this.pathBuffer = stringBuilder.toString();
        }
        return this.pathBuffer.isEmpty() ? "." : this.pathBuffer;
    }

    private StringBuilder getRelativePath(StringBuilder stringBuilder) {
        if (this.optionalParent != null) {
            this.optionalParent.getRelativePath(stringBuilder);
            if (stringBuilder.length() > 0) {
                stringBuilder.append(File.separatorChar);
            }
            stringBuilder.append(this.nameElement);
        }
        return stringBuilder;
    }

    protected boolean hasParent() {
        return this.optionalParent != null;
    }

    public String getPathElement() {
        return this.nameElement;
    }

    @Override
    public boolean isWorkingDirectory() {
        return this.optionalParent == null;
    }

    @Override
    public boolean isChild() {
        return !Paths.get(this.getRelativePath(), new String[0]).startsWith(SUPER_DIRECTORY);
    }

    @Override
    public String toString() {
        return this.getRelativePath();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RelativePath)) {
            return false;
        }
        RelativePath that = (RelativePath)other;
        return that.getRelativePath().equals(this.getRelativePath());
    }

    @Override
    public int hashCode() {
        return this.getRelativePath().hashCode();
    }
}

