/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.transportable.filecontent;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.io.Files;
import java.nio.file.Path;
import java.util.List;
import org.sosy_lab.verifiercloud.transportable.filecontent.FileContent;

public abstract class AbstractFileContent
implements FileContent {
    private static final long serialVersionUID = 1L;
    private static transient boolean writeRepresentationOnDeserialisation;
    private static transient Path deserialisationPath;
    private static final Splitter nameSplitter;

    protected static boolean getWriteRepresentationOnDeserialisation() {
        return writeRepresentationOnDeserialisation;
    }

    public static void setWriteRepresentationOnDeserialisation(boolean writeRepresentationOnDeserialisation) {
        AbstractFileContent.writeRepresentationOnDeserialisation = writeRepresentationOnDeserialisation;
    }

    protected static Path getDeserialisationPath() {
        Preconditions.checkState(deserialisationPath != null);
        return deserialisationPath;
    }

    public static void setDeserializationPath(Path deserialisationPath) {
        AbstractFileContent.deserialisationPath = deserialisationPath;
    }

    public int hashCode() {
        return this.getFileHash().hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FileContent)) {
            return false;
        }
        FileContent that = (FileContent)other;
        return this.getFileHash().equals(that.getFileHash());
    }

    public String toString() {
        return "File[" + this.getFileHash() + "]";
    }

    public static List<String> getFileNameTokens(Path file) {
        String fileName = file.getFileName().toString();
        return nameSplitter.splitToList(Files.getNameWithoutExtension(fileName));
    }

    static {
        nameSplitter = Splitter.on('_');
    }
}

