/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.transportable.filecontent;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.Immutable;
import org.sosy_lab.verifiercloud.global.util.HashUtils;
import org.sosy_lab.verifiercloud.transportable.filecontent.AbstractFileContent;
import org.sosy_lab.verifiercloud.transportable.filecontent.CorruptedFileException;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;

@Immutable
public class BigFileContent
extends AbstractFileContent {
    private static final long serialVersionUID = 1L;
    private final MemoryUnit fileSize;
    private final HashCode fileHash;
    private transient Path content;
    private final transient AtomicBoolean tmpFile = new AtomicBoolean(false);

    public static BigFileContent fromPath(Path file) throws IOException {
        MemoryUnit fileSize = MemoryUnit.bytes(Files.size(file));
        HashCode fileHash = HashUtils.hashFile(file);
        return new BigFileContent(file, fileHash, fileSize);
    }

    public static BigFileContent fromRepresentation(Path file, boolean skipRehashing) throws IOException, CorruptedFileException {
        Preconditions.checkArgument(Files.isRegularFile(file, new LinkOption[0]), "%s is not a regular file.", file);
        List<String> tokens = BigFileContent.getFileNameTokens(file);
        Preconditions.checkArgument(tokens.size() == 2);
        MemoryUnit fileSize = MemoryUnit.bytes(Files.size(file));
        HashCode fileNameHash = HashCode.fromString(tokens.get(0));
        if (skipRehashing) {
            MemoryUnit fileNameSize = MemoryUnit.fromString(tokens.get(1));
            if (!fileSize.equals(fileNameSize)) {
                throw new CorruptedFileException(file + " has invalid file size.");
            }
        } else {
            HashCode fileHash = HashUtils.hashFile(file);
            if (!fileHash.equals(fileNameHash)) {
                throw new CorruptedFileException(file + " has invalid file hash.");
            }
        }
        return new BigFileContent(file, fileNameHash, fileSize);
    }

    private BigFileContent(Path file, HashCode fileHash, MemoryUnit fileSize) throws IOException {
        this.fileSize = Preconditions.checkNotNull(fileSize);
        this.fileHash = Preconditions.checkNotNull(fileHash);
        this.content = Preconditions.checkNotNull(file);
    }

    @Override
    public HashCode getFileHash() {
        return this.fileHash;
    }

    @Override
    public MemoryUnit getFileSize() {
        return this.fileSize;
    }

    @Override
    public MemoryUnit getRepresentationSize() {
        return this.fileSize;
    }

    @Override
    public void writeToPath(Path targetPath) throws IOException {
        if (this.tmpFile.getAndSet(false)) {
            Files.move(this.content, targetPath, new CopyOption[0]);
            this.content = targetPath;
        } else {
            try {
                Files.createLink(targetPath, this.content);
            }
            catch (IOException e) {
                Files.copy(this.content, targetPath, new CopyOption[0]);
            }
        }
    }

    @Override
    public Path writeRepresentationToPath(Path targetDir) throws IOException {
        Preconditions.checkArgument(Files.isDirectory(targetDir, new LinkOption[0]));
        String fileName = String.format("%s_%s", this.fileHash, Files.size(this.content));
        Path file = targetDir.resolve(fileName);
        this.writeToPath(file);
        return file;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getContent() {
        try (InputStream inputStream = Files.newInputStream(this.content, new OpenOption[0]);){
            byte[] contentByte = ByteStreams.toByteArray(inputStream);
            String string = new String(contentByte, Charsets.UTF_8);
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ByteSource getContentAsByteSource() {
        return com.google.common.io.Files.asByteSource(this.content.toFile());
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.fileHash);
        oos.writeObject(this.fileSize);
        com.google.common.io.Files.copy(this.content.toFile(), oos);
    }

    private void readObject(ObjectInputStream ois) throws IOException {
        MemoryUnit fileSize;
        HashCode fileHash;
        try {
            fileHash = (HashCode)ois.readObject();
            fileSize = (MemoryUnit)ois.readObject();
        }
        catch (ClassCastException | ClassNotFoundException e) {
            throw new IOException(e);
        }
        this.content = BigFileContent.getUnambiguousFilePath(fileHash);
        Files.createDirectories(this.content.getParent(), new FileAttribute[0]);
        try {
            Field fileHashField = this.getClass().getDeclaredField("fileHash");
            fileHashField.setAccessible(true);
            fileHashField.set(this, fileHash);
            Field fileSizeField = this.getClass().getDeclaredField("fileSize");
            fileSizeField.setAccessible(true);
            fileSizeField.set(this, fileSize);
            Field tmpFileField = this.getClass().getDeclaredField("tmpFile");
            tmpFileField.setAccessible(true);
            tmpFileField.set(this, new AtomicBoolean(true));
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new IOException(e);
        }
        InputStream contentStream = ByteStreams.limit(ois, fileSize.toByte());
        Files.copy(contentStream, this.content, new CopyOption[0]);
    }

    private static Path getUnambiguousFilePath(HashCode fileNamePrefix) {
        Path dir = BigFileContent.getDeserialisationPath();
        StringBuilder unambiguousFileName = new StringBuilder();
        unambiguousFileName.append(fileNamePrefix).append(UUID.randomUUID());
        Path unambiguousFilePath = dir.resolve(unambiguousFileName.toString());
        while (Files.exists(unambiguousFilePath, new LinkOption[0])) {
            unambiguousFileName.append('_');
            unambiguousFilePath = dir.resolve(unambiguousFileName.toString());
        }
        return unambiguousFilePath;
    }
}

