/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.transportable.filecontent;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import com.google.common.io.ByteSource;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.sosy_lab.verifiercloud.global.util.HashUtils;
import org.sosy_lab.verifiercloud.transportable.filecontent.AbstractFileContent;
import org.sosy_lab.verifiercloud.transportable.filecontent.CorruptedFileException;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;

@Immutable
public class DefaultFileContent
extends AbstractFileContent {
    private static final long serialVersionUID = 2L;
    private final byte[] fileContent;
    private final HashCode fileHash;

    public static DefaultFileContent fromPath(Path file) throws IOException {
        return new DefaultFileContent(file);
    }

    public static DefaultFileContent fromRepresentation(Path file, boolean skipRehashing) throws IOException, CorruptedFileException {
        Preconditions.checkArgument(Files.isRegularFile(file, new LinkOption[0]), "%s is not a regular file.", file);
        List<String> tokens = DefaultFileContent.getFileNameTokens(file);
        Preconditions.checkArgument(tokens.size() == 2);
        byte[] fileContent = Files.readAllBytes(file);
        MemoryUnit fileSize = MemoryUnit.bytes(fileContent.length);
        HashCode fileNameHash = HashCode.fromString(tokens.get(0));
        if (skipRehashing) {
            MemoryUnit fileNameSize = MemoryUnit.fromString(tokens.get(1));
            if (!fileSize.equals(fileNameSize)) {
                throw new CorruptedFileException(file + " has invalid file size.");
            }
        } else {
            HashCode fileHash = HashUtils.hashFile(file);
            if (!fileHash.equals(fileNameHash)) {
                throw new CorruptedFileException(file + " has invalid file hash.");
            }
        }
        return new DefaultFileContent(fileContent, fileNameHash);
    }

    public static DefaultFileContent fromBytes(byte[] content) {
        return new DefaultFileContent(content);
    }

    public static DefaultFileContent fromString(String content) {
        return new DefaultFileContent(content);
    }

    private DefaultFileContent(Path pathToFile) throws IOException {
        Preconditions.checkNotNull(pathToFile);
        Preconditions.checkArgument(Files.isRegularFile(pathToFile, new LinkOption[0]), "%s is not a regular file.", pathToFile);
        this.fileContent = Files.readAllBytes(pathToFile);
        this.fileHash = HashUtils.getSha1Hash(this.fileContent);
    }

    private DefaultFileContent(byte[] fileContent, HashCode fileHash) throws IOException {
        this.fileContent = Preconditions.checkNotNull(fileContent);
        this.fileHash = Preconditions.checkNotNull(fileHash);
    }

    private DefaultFileContent(byte[] fileContent) {
        this.fileContent = Preconditions.checkNotNull(fileContent);
        this.fileHash = HashUtils.getSha1Hash(fileContent);
    }

    private DefaultFileContent(String fileContent) {
        this(fileContent.getBytes(Charsets.UTF_8));
    }

    @Override
    public HashCode getFileHash() {
        return this.fileHash;
    }

    @Override
    public MemoryUnit getFileSize() {
        return MemoryUnit.bytes(this.fileContent.length);
    }

    @Override
    public MemoryUnit getRepresentationSize() {
        return MemoryUnit.bytes(this.fileContent.length);
    }

    @Override
    public void writeToPath(Path targetPath) throws IOException {
        Files.write(targetPath, this.fileContent, StandardOpenOption.CREATE_NEW);
    }

    @Override
    public Path writeRepresentationToPath(Path targetDir) throws IOException {
        Preconditions.checkArgument(Files.isDirectory(targetDir, new LinkOption[0]));
        String fileName = String.format("%s_%s", this.fileHash, this.fileContent.length);
        Path file = targetDir.resolve(fileName);
        this.writeToPath(file);
        return file;
    }

    @Override
    public String getContent() {
        return new String(this.fileContent, Charsets.UTF_8);
    }

    @Override
    public ByteSource getContentAsByteSource() {
        return ByteSource.wrap(this.fileContent);
    }
}

