/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.transportable.filecontent;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import com.google.common.io.ByteSource;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.concurrent.Immutable;
import org.sosy_lab.verifiercloud.global.util.HashUtils;
import org.sosy_lab.verifiercloud.transportable.filecontent.CorruptedFileException;
import org.sosy_lab.verifiercloud.transportable.filecontent.FileContent;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;

@Immutable
public class EmptyFileContent
implements FileContent {
    private static final long serialVersionUID = 2L;
    private static final HashCode EMPTY_FILE_HASH = HashUtils.getSha1Hash("".getBytes(Charsets.UTF_8));
    private static final Path FILE_NAME = Paths.get(EMPTY_FILE_HASH + "_0", new String[0]);
    private static final String DESCRIPTION = "File[" + EMPTY_FILE_HASH + "]";

    public static EmptyFileContent fromRepresentation(Path file) throws CorruptedFileException, IOException {
        Preconditions.checkArgument(Files.size(file) == 0L);
        if (file.getFileName().equals(FILE_NAME)) {
            return new EmptyFileContent();
        }
        throw new CorruptedFileException("Invalid file name of empty file content");
    }

    @Override
    public HashCode getFileHash() {
        return EMPTY_FILE_HASH;
    }

    @Override
    public MemoryUnit getFileSize() {
        return MemoryUnit.zero();
    }

    @Override
    public MemoryUnit getRepresentationSize() {
        return MemoryUnit.zero();
    }

    @Override
    public void writeToPath(Path targetPath) throws IOException {
        Files.write(targetPath, "".getBytes(Charsets.UTF_8), new OpenOption[0]);
    }

    @Override
    public Path writeRepresentationToPath(Path targetDir) throws IOException {
        Preconditions.checkArgument(Files.isDirectory(targetDir, new LinkOption[0]));
        Path file = targetDir.resolve(EMPTY_FILE_HASH + "_0");
        this.writeToPath(file);
        return file;
    }

    @Override
    public String getContent() {
        return "";
    }

    public boolean equals(Object other) {
        if (!(other instanceof FileContent)) {
            return false;
        }
        FileContent that = (FileContent)other;
        return that.getFileHash().equals(EMPTY_FILE_HASH);
    }

    public int hashCode() {
        return EMPTY_FILE_HASH.hashCode();
    }

    public String toString() {
        return DESCRIPTION;
    }

    @Override
    public ByteSource getContentAsByteSource() {
        return ByteSource.empty();
    }
}

