/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.transportable.filecontent;

import com.google.common.base.Charsets;
import com.google.common.hash.HashCode;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.sosy_lab.verifiercloud.global.logging.LoggerBuilder;
import org.sosy_lab.verifiercloud.global.processes.ProcessExecutor;
import org.sosy_lab.verifiercloud.global.util.FileUtils;
import org.sosy_lab.verifiercloud.global.util.HashUtils;
import org.sosy_lab.verifiercloud.transportable.filecontent.AbstractFileContent;
import org.sosy_lab.verifiercloud.transportable.filecontent.CorruptedFileException;
import org.sosy_lab.verifiercloud.transportable.filecontent.FileContent;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;

public abstract class FileContentTestBase {
    private static Path tempDirectory;
    private Path pathToTempDir;

    @BeforeClass
    public static void setUpClass() throws Exception {
        tempDirectory = Files.createTempDirectory("vcloud-test-BigFileContentTest-deserialization", new FileAttribute[0]);
        AbstractFileContent.setDeserializationPath(tempDirectory);
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        FileUtils.deleteDirectory(tempDirectory, LoggerBuilder.create().build());
    }

    @Before
    public void setUp() throws Exception {
        this.pathToTempDir = Files.createTempDirectory("vcloud-test-FileContentTestBase", new FileAttribute[0]);
    }

    @Test
    public void testWriteToPath() throws Exception {
        Path targetPath = this.pathToTempDir.resolve("somefile");
        FileContent fileContent = this.createFileContent();
        fileContent.writeToPath(targetPath);
        HashCode originalFileHash = fileContent.getFileHash();
        HashCode actualFileHash = HashUtils.hashFile(targetPath);
        Assert.assertEquals((Object)originalFileHash, (Object)actualFileHash);
    }

    @Test(expected=IOException.class)
    public void testOverwrite() throws Exception {
        Path path = this.pathToTempDir.resolve("filename");
        try {
            Files.write(path, "some content".getBytes(Charsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            Assert.fail((String)("This is not part of the test case: " + e.getMessage()));
        }
        FileContent fileContent = this.createFileContent();
        fileContent.writeToPath(path);
    }

    @Test
    public void testFileSize() throws Exception {
        String content = "test file content";
        FileContent fileContent = this.createFileContent(content);
        Assert.assertEquals((Object)fileContent.getFileSize(), (Object)MemoryUnit.bytes(content.length()));
    }

    @Test
    public void testEquals() throws Exception {
        String commonFileContent = "test file content";
        FileContent fileContent1 = this.createFileContent(commonFileContent);
        FileContent fileContent2 = this.createFileContent(commonFileContent);
        Assert.assertEquals((Object)fileContent1, (Object)fileContent2);
    }

    @Test
    public void testGetFileContent() throws IOException {
        FileContent fileContent = this.createFileContent("some bytes");
        Assert.assertEquals((Object)"some bytes", (Object)fileContent.getContent());
    }

    @Test
    public void testGetFileContentAsByteSource() throws IOException {
        byte[] someBytes = "some bytes".getBytes(Charsets.UTF_8);
        FileContent fileContent = this.createFileContent(someBytes);
        byte[] readContent = fileContent.getContentAsByteSource().read();
        Assert.assertArrayEquals((byte[])someBytes, (byte[])readContent);
    }

    @Test
    public void testSerialization() throws IOException, ClassNotFoundException {
        FileContent readFileContent;
        Path tmpFile = Files.createTempFile("vcloud-test-FileContentTestBase", null, new FileAttribute[0]);
        FileContent fileContent = this.createFileContent();
        try (ObjectOutputStream oos = new ObjectOutputStream(Files.newOutputStream(tmpFile, new OpenOption[0]));){
            oos.writeObject(fileContent);
        }
        try (ObjectInputStream ois = new ObjectInputStream(Files.newInputStream(tmpFile, new OpenOption[0]));){
            readFileContent = (FileContent)ois.readObject();
        }
        Assert.assertEquals((Object)fileContent, (Object)readFileContent);
        Assert.assertEquals((Object)fileContent.getContent(), (Object)readFileContent.getContent());
        Files.delete(tmpFile);
    }

    @Test
    public void testWriteRepresentation() throws IOException, CorruptedFileException {
        FileContent fileContent = this.createFileContent("jngfkljubd\u00f6fg");
        Path file = fileContent.writeRepresentationToPath(this.pathToTempDir);
        FileContent readFileContent = this.createFileFromRepresentation(file);
        Assert.assertEquals((Object)fileContent, (Object)readFileContent);
        FileContent readFileContent2 = FileUtils.getFileContentFromRepresentation(file, true);
        Assert.assertEquals((Object)fileContent, (Object)readFileContent2);
    }

    @After
    public void tearDown() throws Exception {
        ProcessExecutor pe = new ProcessExecutor(LoggerBuilder.create().build());
        pe.executeProcess("rm -r " + this.pathToTempDir.toAbsolutePath().toString());
    }

    protected abstract FileContent createFileContent() throws IOException;

    protected abstract FileContent createFileContent(String var1) throws IOException;

    protected abstract FileContent createFileContent(byte[] var1) throws IOException;

    protected abstract FileContent createFileFromRepresentation(Path var1) throws IOException, CorruptedFileException;

    protected Path getPathToTempDir() {
        return this.pathToTempDir;
    }
}

