/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.transportable.filecontent;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import com.google.common.io.ByteSource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.zip.InflaterInputStream;
import java.util.zip.InflaterOutputStream;
import javax.annotation.concurrent.Immutable;
import org.sosy_lab.verifiercloud.global.util.HashUtils;
import org.sosy_lab.verifiercloud.transportable.filecontent.AbstractFileContent;
import org.sosy_lab.verifiercloud.transportable.filecontent.CorruptedFileException;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;

@Immutable
public class ZipFileContent
extends AbstractFileContent {
    private static final long serialVersionUID = 2L;
    private static final int DEFAULT_COMPRESSION = -1;
    private final byte[] compressedFileContent;
    private final MemoryUnit fileSize;
    private final HashCode fileHash;

    public static ZipFileContent fromFileContent(byte[] fileContent) throws IOException {
        return ZipFileContent.fromFileContent(fileContent, -1);
    }

    public static ZipFileContent fromPath(Path pathToFile) throws IOException {
        return ZipFileContent.fromPath(pathToFile, -1);
    }

    public static ZipFileContent fromRepresentation(Path file, boolean skipRehashing) throws IOException, CorruptedFileException {
        List<String> tokens = ZipFileContent.getFileNameTokens(file);
        Preconditions.checkArgument(tokens.size() == 3);
        byte[] compressedContent = Files.readAllBytes(file);
        HashCode fileNameHash = HashCode.fromString(tokens.get(0));
        MemoryUnit representationNameSize = MemoryUnit.fromString(tokens.get(1));
        MemoryUnit fileNameSize = MemoryUnit.fromString(tokens.get(2));
        if (skipRehashing) {
            MemoryUnit representationSize = MemoryUnit.bytes(compressedContent.length);
            if (!representationSize.equals(representationNameSize)) {
                throw new CorruptedFileException(file + " has invalid file size.");
            }
        } else {
            HashCode fileHash = HashUtils.hashCompressedFile(file);
            if (!fileHash.equals(fileNameHash)) {
                throw new CorruptedFileException(file + " has invalid file hash.");
            }
        }
        return new ZipFileContent(compressedContent, fileNameHash, fileNameSize);
    }

    public static ZipFileContent fromString(String fileContent) throws IOException {
        return ZipFileContent.fromString(fileContent, -1);
    }

    public static ZipFileContent fromPath(Path pathToFile, int compressionLevel) throws IOException {
        Preconditions.checkNotNull(pathToFile);
        Preconditions.checkArgument(Files.isRegularFile(pathToFile, new LinkOption[0]));
        return new ZipFileContent(pathToFile, compressionLevel);
    }

    public static ZipFileContent fromFileContent(byte[] fileContent, int compressionLevel) throws IOException {
        return new ZipFileContent(fileContent, compressionLevel);
    }

    public static ZipFileContent fromString(String fileContent, int compressionLevel) throws IOException {
        return new ZipFileContent(fileContent.getBytes(Charsets.UTF_8), compressionLevel);
    }

    private ZipFileContent(Path file, int compressionLevel) throws IOException {
        this.fileSize = MemoryUnit.bytes(Files.size(file));
        this.fileHash = HashUtils.hashFile(file);
        ByteSource input = com.google.common.io.Files.asByteSource(file.toFile());
        this.compressedFileContent = this.zipStream(input, compressionLevel);
    }

    private ZipFileContent(byte[] fileContent, int compressionLevel) throws IOException {
        Preconditions.checkNotNull(fileContent);
        this.fileSize = MemoryUnit.bytes(fileContent.length);
        this.fileHash = HashUtils.getSha1Hash(fileContent);
        ByteSource input = ByteSource.wrap(fileContent);
        this.compressedFileContent = this.zipStream(input, compressionLevel);
    }

    private ZipFileContent(byte[] compressedFileContent, HashCode fileHash, MemoryUnit fileSize) throws IOException {
        this.fileSize = Preconditions.checkNotNull(fileSize);
        this.fileHash = Preconditions.checkNotNull(fileHash);
        this.compressedFileContent = Preconditions.checkNotNull(compressedFileContent);
    }

    /*
     * Exception decompiling
     */
    private byte[] zipStream(ByteSource input, int compressionLevel) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public HashCode getFileHash() {
        return this.fileHash;
    }

    @Override
    public MemoryUnit getFileSize() {
        return this.fileSize;
    }

    @Override
    public MemoryUnit getRepresentationSize() {
        return MemoryUnit.bytes(this.compressedFileContent.length);
    }

    @Override
    public void writeToPath(Path targetPath) throws IOException {
        try (InflaterOutputStream decompressOS = new InflaterOutputStream(Files.newOutputStream(targetPath, StandardOpenOption.CREATE_NEW));){
            decompressOS.write(this.compressedFileContent);
        }
    }

    @Override
    public Path writeRepresentationToPath(Path targetDir) throws IOException {
        String fileName = String.format("%s_%s_%s.zip", this.fileHash, this.compressedFileContent.length, this.fileSize.toByte());
        Path file = targetDir.resolve(fileName);
        Files.write(file, this.compressedFileContent, StandardOpenOption.CREATE_NEW);
        return file;
    }

    @Override
    public String getContent() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        InflaterOutputStream decompressOS = new InflaterOutputStream(outputStream);
        try {
            decompressOS.write(this.compressedFileContent);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new String(outputStream.toByteArray(), Charsets.UTF_8);
    }

    @Override
    public ByteSource getContentAsByteSource() {
        return new ByteSource(){

            @Override
            public InputStream openStream() throws IOException {
                return new InflaterInputStream(new ByteArrayInputStream(ZipFileContent.this.compressedFileContent));
            }
        };
    }
}

