/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.transportable.info;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import javax.annotation.concurrent.Immutable;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;

@Immutable
public class FileStorageInformation
implements Serializable {
    private static final long serialVersionUID = -7507737231539520592L;
    private final int numberOfFiles;
    private final MemoryUnit storageSize;
    private final MemoryUnit freeSpace;

    public FileStorageInformation(int numberOfFiles, MemoryUnit storageSize, MemoryUnit freeSpace) {
        Preconditions.checkArgument(numberOfFiles >= 0, "Number of files can not be negative.");
        this.numberOfFiles = numberOfFiles;
        this.storageSize = Preconditions.checkNotNull(storageSize);
        this.freeSpace = Preconditions.checkNotNull(freeSpace);
    }

    public int getNumberOfStoredFiles() {
        return this.numberOfFiles;
    }

    public MemoryUnit getStorageSize() {
        return this.storageSize;
    }

    public MemoryUnit getFreeSpace() {
        return this.freeSpace;
    }
}

