/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.transportable.info.master;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.sosy_lab.verifiercloud.global.util.TableFormatter;
import org.sosy_lab.verifiercloud.transportable.info.FileStorageInformation;
import org.sosy_lab.verifiercloud.transportable.info.master.ExternalWorkerState;
import org.sosy_lab.verifiercloud.transportable.info.master.RunCollectionSummary;
import org.sosy_lab.verifiercloud.transportable.info.master.SchedulerSummary;
import org.sosy_lab.verifiercloud.transportable.info.master.WorkerSummary;
import org.sosy_lab.verifiercloud.transportable.info.worker.LoadData;
import org.sosy_lab.verifiercloud.transportable.info.worker.WorkerPartitionInformation;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;
import org.sosy_lab.verifiercloud.transportable.units.time.TimeInterval;

@Immutable
public class MasterSummary
implements Serializable {
    private static final long serialVersionUID = 8222351048457114586L;
    private final TimeInterval uptime;
    private final int masterProcessorCount;
    private final LoadData load;
    private final ImmutableList<WorkerSummary> workerSummaries;
    private final ImmutableList<String> availableHosts;
    private final SchedulerSummary schedulerSummary;
    private final FileStorageInformation masterFileStorageInformation;

    public MasterSummary(TimeInterval uptime, int processorCount, LoadData load, List<WorkerSummary> workerSummary, List<String> availableHosts, SchedulerSummary runCollectionSummary, FileStorageInformation masterFileStorageInformation) {
        this.uptime = Preconditions.checkNotNull(uptime);
        this.masterProcessorCount = processorCount;
        this.load = Preconditions.checkNotNull(load);
        this.workerSummaries = ImmutableList.copyOf((Collection)Preconditions.checkNotNull(workerSummary));
        this.availableHosts = ImmutableList.copyOf((Collection)Preconditions.checkNotNull(availableHosts));
        this.schedulerSummary = Preconditions.checkNotNull(runCollectionSummary);
        this.masterFileStorageInformation = Preconditions.checkNotNull(masterFileStorageInformation);
    }

    public TimeInterval getUptime() {
        return this.uptime;
    }

    public int getMasterProcessorCount() {
        return this.masterProcessorCount;
    }

    public LoadData getLoad() {
        return this.load;
    }

    public ImmutableList<WorkerSummary> getWorkerSummaries() {
        return this.workerSummaries;
    }

    public SchedulerSummary getSchedulerSummary() {
        return this.schedulerSummary;
    }

    public FileStorageInformation getFileStorageInformation() {
        return this.masterFileStorageInformation;
    }

    public List<String> getUnconnectedWorkers() {
        return FluentIterable.from(this.availableHosts).filter(new HostIsAvailablePredicate()).toSortedList(Ordering.natural());
    }

    public String getDetailedDescription() {
        TableFormatter formatter = new TableFormatter(2, 2);
        formatter.addRow("Uptime:", this.uptime);
        formatter.addRow("Number of workers (idle, occupied by user):", String.format("%d (%d, %d)", this.workerSummaries.size(), this.getNumberOfIdleWorkers(), this.getNumberOfUserOccupiedWorkers()));
        if (!this.getUnconnectedWorkers().isEmpty()) {
            formatter.addRow("Unconnected workers:", Joiner.on(", ").join(this.getUnconnectedWorkers()));
        }
        formatter.addRow("Number of RunCollections:", this.schedulerSummary.getNumberOfRunCollections());
        formatter.addRow("Unfinished runs:", this.schedulerSummary.getNumberOfAssignedRuns() + this.schedulerSummary.getNumberOfUnassignedRuns());
        formatter.addRow("Stored files:", this.masterFileStorageInformation.getNumberOfStoredFiles());
        formatter.addRow("Stored file size:", this.masterFileStorageInformation.getStorageSize());
        String table = formatter.buildTable();
        return "Master\n" + table;
    }

    public String getTabularWorkerView() {
        ImmutableList<WorkerSummary> sortedWorkers = FluentIterable.from(this.workerSummaries).toSortedList(new WorkerNameComparator());
        StringBuilder table = new StringBuilder();
        for (WorkerSummary worker : sortedWorkers) {
            table.append(worker.toString()).append('\n');
            ImmutableCollection<WorkerPartitionInformation> partitions = worker.getExecutorState().getPartitions();
            Iterator partitionIt = partitions.iterator();
            while (partitionIt.hasNext()) {
                WorkerPartitionInformation partition = (WorkerPartitionInformation)partitionIt.next();
                StringBuilder partitionString = new StringBuilder(" ");
                partitionString.append(partitionIt.hasNext() ? "\u251c>" : "\u2514>");
                partitionString.append("           ");
                partitionString.append(String.format("%-20s", partition.getState().toString()));
                int partitionProcessors = partition.getNumberOfProcessors();
                partitionString.append('[');
                partitionString.append(partitionProcessors).append(partitionProcessors > 1 ? " processors" : " processor");
                partitionString.append(", ");
                partitionString.append(partition.getReservedMemory());
                partitionString.append(']');
                partitionString.append('\n');
                table.append((CharSequence)partitionString);
            }
        }
        return table.toString();
    }

    public String getTabularRunCollectionsView() {
        ImmutableCollection<RunCollectionSummary> runCollections = this.schedulerSummary.getRunCollections();
        Object[] tableHeader = new Object[]{"Id", "Owner", "Priority", "Runs", "Finished"};
        TableFormatter table = new TableFormatter(tableHeader.length, 0);
        table.addRow(tableHeader);
        for (RunCollectionSummary runCollection : runCollections) {
            table.addRow(new Object[]{runCollection.getId(), runCollection.getOwner(), runCollection.getPriority(), runCollection.getNumberOfRuns(), runCollection.getNumberOfFinishedRuns()});
        }
        return table.buildTable();
    }

    public String toString() {
        return String.format("Master(workers=%d)", this.workerSummaries.size());
    }

    public int getNumberOfWorkingWorkers() {
        return FluentIterable.from(this.workerSummaries).filter(new WorkerIsWorkingPredicate()).size();
    }

    public int getNumberOfIdleWorkers() {
        return FluentIterable.from(this.workerSummaries).filter(new WorkerIsIdlePredicate()).size();
    }

    public int getNumberOfUserOccupiedWorkers() {
        return FluentIterable.from(this.workerSummaries).filter(new WorkerIsOccupiedPredicate()).size();
    }

    public int getNumberOfProcessors() {
        int overallProcessors = 0;
        for (WorkerSummary worker : this.workerSummaries) {
            overallProcessors += worker.getNumberOfProcessors();
        }
        return overallProcessors;
    }

    public int getNumberOfAssignedProcessors() {
        int assignedProcessors = 0;
        for (WorkerSummary worker : this.workerSummaries) {
            assignedProcessors += worker.getNumberOfReservedProcessors();
        }
        return assignedProcessors;
    }

    public int getNumberOfFreeProcessors() {
        int allProcessors = this.getNumberOfProcessors();
        int assignedProcessors = this.getNumberOfAssignedProcessors();
        int unusable = 0;
        for (WorkerSummary worker : this.workerSummaries) {
            unusable += worker.getNumberOfUnusableProcessors();
        }
        int freeProcessors = allProcessors - unusable - assignedProcessors;
        Preconditions.checkState(freeProcessors >= 0, "Free Processors is %s.", freeProcessors);
        return freeProcessors;
    }

    public MemoryUnit getRAM() {
        long memoryInByte = 0L;
        for (WorkerSummary worker : this.workerSummaries) {
            memoryInByte += worker.getTotalMemory().toByte();
        }
        return MemoryUnit.bytes(memoryInByte);
    }

    public MemoryUnit getAssignedRAM() {
        long assignedMemoryInByte = 0L;
        for (WorkerSummary worker : this.workerSummaries) {
            assignedMemoryInByte += worker.getReservedMemory().toByte();
        }
        return MemoryUnit.bytes(assignedMemoryInByte);
    }

    public MemoryUnit getFreeRAM() {
        long freeRAMInByte = 0L;
        for (WorkerSummary worker : this.workerSummaries) {
            freeRAMInByte += worker.getFreeMemory().toByte();
        }
        return MemoryUnit.bytes(freeRAMInByte);
    }

    public Set<String> getAllProcessorModels(Predicate<WorkerSummary> filter) {
        return FluentIterable.from(this.workerSummaries).filter(filter).transform(new WorkerToCpuNameFunction()).toSet();
    }

    private static final class WorkerIsWorkingPredicate
    implements Predicate<WorkerSummary> {
        private WorkerIsWorkingPredicate() {
        }

        @Override
        public boolean apply(@Nonnull WorkerSummary worker) {
            Preconditions.checkNotNull(worker);
            return worker.getWorkerState() == ExternalWorkerState.AVAILABLE && !worker.getExecutorState().getPartitions().isEmpty();
        }
    }

    private static final class WorkerIsIdlePredicate
    implements Predicate<WorkerSummary> {
        private WorkerIsIdlePredicate() {
        }

        @Override
        public boolean apply(@Nonnull WorkerSummary worker) {
            Preconditions.checkNotNull(worker);
            return worker.getWorkerState() == ExternalWorkerState.AVAILABLE && worker.getExecutorState().getPartitions().isEmpty();
        }
    }

    private static final class WorkerIsOccupiedPredicate
    implements Predicate<WorkerSummary> {
        private WorkerIsOccupiedPredicate() {
        }

        @Override
        public boolean apply(@Nonnull WorkerSummary worker) {
            Preconditions.checkNotNull(worker);
            return worker.getWorkerState() == ExternalWorkerState.USER_OCCUPIED;
        }
    }

    private static final class WorkerNameComparator
    implements Comparator<WorkerSummary>,
    Serializable {
        private static final long serialVersionUID = 8770008204153364884L;

        private WorkerNameComparator() {
        }

        @Override
        public int compare(WorkerSummary o1, WorkerSummary o2) {
            return o1.getWorkerHostname().compareToIgnoreCase(o2.getWorkerHostname());
        }
    }

    private final class HostIsAvailablePredicate
    implements Predicate<String> {
        private final Set<String> connectedHosts = Sets.newHashSet();

        private HostIsAvailablePredicate() {
            for (WorkerSummary worker : MasterSummary.this.workerSummaries) {
                this.connectedHosts.add(worker.getWorkerHostname());
                if (!worker.getStartupHostname().isPresent()) continue;
                this.connectedHosts.add(worker.getStartupHostname().get());
            }
        }

        @Override
        public boolean apply(String worker) {
            return !this.connectedHosts.contains(worker);
        }
    }

    private static class WorkerToCpuNameFunction
    implements Function<WorkerSummary, String> {
        private WorkerToCpuNameFunction() {
        }

        @Override
        public String apply(WorkerSummary workerSummary) {
            return workerSummary.getCPUName();
        }
    }
}

