/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.transportable.info.master;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import javax.annotation.concurrent.Immutable;
import org.sosy_lab.verifiercloud.transportable.collections.SchedulingPriority;
import org.sosy_lab.verifiercloud.transportable.run.constraints.limitations.Limitations;
import org.sosy_lab.verifiercloud.transportable.run.constraints.requirements.ScheduledRequirements;
import org.sosy_lab.verifiercloud.transportable.units.time.TimeInterval;

@Immutable
public class RunCollectionSummary
implements Serializable {
    private static final long serialVersionUID = 6770113886251397215L;
    private final String id;
    private final String name;
    private final int numberOfRuns;
    private final int numberOfFinishedRuns;
    private final String owner;
    private final long timeAddedMillis;
    private final TimeInterval consumedWallTime;
    private final SchedulingPriority priority;
    private final boolean detachable;
    private final ScheduledRequirements requirements;
    private final ImmutableSet<Limitations> limitations;

    public RunCollectionSummary(String id, String name, int numberOfRuns, int numberOfFinishedRuns, String owner, long timeAddedMillis, TimeInterval consumedWallTime, ScheduledRequirements requirements, ImmutableSet<Limitations> limitations, SchedulingPriority priority, boolean detachable) {
        this.requirements = Preconditions.checkNotNull(requirements);
        this.limitations = Preconditions.checkNotNull(limitations);
        Preconditions.checkArgument(!Strings.isNullOrEmpty(id));
        this.id = id;
        this.name = Preconditions.checkNotNull(name);
        Preconditions.checkArgument(numberOfRuns >= 0);
        this.numberOfRuns = numberOfRuns;
        Preconditions.checkArgument(numberOfFinishedRuns >= 0);
        Preconditions.checkArgument(numberOfFinishedRuns <= numberOfRuns);
        this.numberOfFinishedRuns = numberOfFinishedRuns;
        Preconditions.checkArgument(!Strings.isNullOrEmpty(owner));
        this.owner = owner;
        Preconditions.checkArgument(timeAddedMillis > 0L);
        Preconditions.checkArgument(timeAddedMillis <= System.currentTimeMillis());
        this.timeAddedMillis = timeAddedMillis;
        this.consumedWallTime = Preconditions.checkNotNull(consumedWallTime);
        this.priority = Preconditions.checkNotNull(priority);
        this.detachable = detachable;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getNumberOfRuns() {
        return this.numberOfRuns;
    }

    public int getNumberOfFinishedRuns() {
        return this.numberOfFinishedRuns;
    }

    public String getOwner() {
        return this.owner;
    }

    public boolean isDetachable() {
        return this.detachable;
    }

    public long getTimeAddedMillis() {
        return this.timeAddedMillis;
    }

    public SchedulingPriority getPriority() {
        return this.priority;
    }

    public TimeInterval getConsumedWallTime() {
        return this.consumedWallTime;
    }

    public ScheduledRequirements getRequirements() {
        return this.requirements;
    }

    public ImmutableSet<Limitations> getLimitations() {
        return this.limitations;
    }
}

