/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.transportable.info.master;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import javax.annotation.concurrent.Immutable;
import org.sosy_lab.verifiercloud.transportable.info.master.RunCollectionSummary;
import org.sosy_lab.verifiercloud.transportable.units.time.TimeInterval;

@Immutable
public class SchedulerSummary
implements Serializable {
    private static final long serialVersionUID = 7421150010115339102L;
    private final ImmutableCollection<RunCollectionSummary> runCollectionSummaries;
    private final int numberOfUnassignedRuns;
    private final int numberOfAssignedRuns;
    private final int numberOfFinishedRuns;
    private final TimeInterval timeConsumedByFinishedRuns;
    private final TimeInterval accumulatedRunWaitingTime;

    public SchedulerSummary(ImmutableList<RunCollectionSummary> runCollectionSummaries, int numberOfAssignedRuns, int numberOfUnassignedRuns, int numberOfFinishedRuns, TimeInterval timeConsumedByFinishedRuns, TimeInterval accumulatedRunWaitingTime) {
        this.runCollectionSummaries = Preconditions.checkNotNull(runCollectionSummaries);
        Preconditions.checkArgument(numberOfAssignedRuns >= 0, "%s is not a legal number of Runs.", numberOfAssignedRuns);
        this.numberOfAssignedRuns = numberOfAssignedRuns;
        Preconditions.checkArgument(numberOfUnassignedRuns >= 0, "%s is not a legal number of Runs.", numberOfUnassignedRuns);
        this.numberOfUnassignedRuns = numberOfUnassignedRuns;
        Preconditions.checkArgument(numberOfFinishedRuns >= 0, "%s is not a legal number of Runs.", numberOfFinishedRuns);
        this.numberOfFinishedRuns = numberOfFinishedRuns;
        this.timeConsumedByFinishedRuns = Preconditions.checkNotNull(timeConsumedByFinishedRuns);
        this.accumulatedRunWaitingTime = Preconditions.checkNotNull(accumulatedRunWaitingTime);
    }

    public int getNumberOfAllKnownRuns() {
        int runs = 0;
        for (RunCollectionSummary runCollection : this.runCollectionSummaries) {
            runs += runCollection.getNumberOfRuns();
        }
        return runs;
    }

    public int getNumberOfRunCollections() {
        return this.runCollectionSummaries.size();
    }

    public int getNumberOfUnassignedRuns() {
        return this.numberOfUnassignedRuns;
    }

    public int getNumberOfAssignedRuns() {
        return this.numberOfAssignedRuns;
    }

    public ImmutableCollection<RunCollectionSummary> getRunCollections() {
        return this.runCollectionSummaries;
    }

    public int getNumberOfFinishedRuns() {
        return this.numberOfFinishedRuns;
    }

    public TimeInterval getTimeConsumedByFinishedRuns() {
        return this.timeConsumedByFinishedRuns;
    }

    public TimeInterval getAccumulatedRunWaitingTime() {
        return this.accumulatedRunWaitingTime;
    }
}

