/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.transportable.info.master;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.HashSet;
import javax.annotation.concurrent.Immutable;
import org.sosy_lab.verifiercloud.global.Constants;
import org.sosy_lab.verifiercloud.global.util.TableFormatter;
import org.sosy_lab.verifiercloud.transportable.info.FileStorageInformation;
import org.sosy_lab.verifiercloud.transportable.info.master.ExternalWorkerState;
import org.sosy_lab.verifiercloud.transportable.info.processors.Processor;
import org.sosy_lab.verifiercloud.transportable.info.worker.ExecutorState;
import org.sosy_lab.verifiercloud.transportable.info.worker.LoadData;
import org.sosy_lab.verifiercloud.transportable.info.worker.WorkerRuntimeInformation;
import org.sosy_lab.verifiercloud.transportable.info.worker.WorkerStatistic;
import org.sosy_lab.verifiercloud.transportable.info.worker.constant.HostInformation;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;
import org.sosy_lab.verifiercloud.transportable.units.time.TimeInterval;

@Immutable
public class WorkerSummary
implements Serializable {
    private static final long serialVersionUID = 874167932639399038L;
    private final HostInformation hostInformation;
    private final Optional<String> workerStartupHostname;
    private final ExternalWorkerState workerState;
    private final ExecutorState executorState;
    private final WorkerRuntimeInformation workerRuntimeInformation;
    private final MemoryUnit reservedMemory;
    private final int numberOfReservedProcesseors;

    public WorkerSummary(ExternalWorkerState stateDescription, Optional<String> workerStartupHostname, ExecutorState executorState, HostInformation hostInformation, WorkerRuntimeInformation workerRuntimeInformation, MemoryUnit reservedMemory, int numberOfReservedProcesseors) {
        this.workerState = Preconditions.checkNotNull(stateDescription);
        this.workerStartupHostname = Preconditions.checkNotNull(workerStartupHostname);
        this.executorState = Preconditions.checkNotNull(executorState);
        this.hostInformation = Preconditions.checkNotNull(hostInformation);
        this.workerRuntimeInformation = Preconditions.checkNotNull(workerRuntimeInformation);
        this.reservedMemory = Preconditions.checkNotNull(reservedMemory);
        this.numberOfReservedProcesseors = numberOfReservedProcesseors;
        this.getUnreservedMemory();
        this.getNumberOfUnreservedProcessors();
    }

    public String getWorkerHostname() {
        return this.hostInformation.getHostname();
    }

    public ExternalWorkerState getWorkerState() {
        return this.workerState;
    }

    public ExecutorState getExecutorState() {
        return this.executorState;
    }

    public String getSystemDescription() {
        return this.hostInformation.getCPUName() + " [" + this.hostInformation.getNumberOfProcessors() + " processors, " + this.hostInformation.getTotalMemory() + " memory]";
    }

    public String getCPUName() {
        return this.hostInformation.getCPUName();
    }

    public int getNumberOfProcessors() {
        return this.hostInformation.getNumberOfProcessors();
    }

    public int getNumberOfReservedProcessors() {
        return this.numberOfReservedProcesseors;
    }

    public int getNumberOfUnusableProcessors() {
        return this.workerRuntimeInformation.getUnusableProcessors().size();
    }

    public int getNumberOfUnreservedProcessors() {
        int unusable;
        int reserved;
        int total = this.getNumberOfProcessors();
        int unreservedProcessors = total - ((reserved = this.getNumberOfReservedProcessors()) + (unusable = this.getNumberOfUnusableProcessors()));
        Preconditions.checkArgument(unreservedProcessors >= 0, "unreserved processors:" + unreservedProcessors + ", total processors:" + total + ", reserved processors:" + reserved + ", unusable processors:" + unusable);
        return unreservedProcessors;
    }

    public MemoryUnit getTotalMemory() {
        return this.hostInformation.getTotalMemory();
    }

    public MemoryUnit getUsedMemory() {
        return this.getTotalMemory().minus(this.getFreeMemory());
    }

    public MemoryUnit getFreeMemory() {
        return this.workerRuntimeInformation.getFreeMemory();
    }

    public MemoryUnit getReservedMemory() {
        return this.reservedMemory;
    }

    public MemoryUnit getUnreservedMemory() {
        long unusable;
        long system;
        long reserved;
        long total = this.getTotalMemory().toByte();
        long unreservedBytes = total - ((reserved = this.getReservedMemory().toByte()) + (system = Constants.SYSTEM_MEMORY.toByte()) + (unusable = this.getUnusableMemory().toByte()));
        Preconditions.checkArgument(unreservedBytes >= 0L, "unreserved memory:" + unreservedBytes + ", total memory:" + total + ", reserved memory:" + reserved + ", system memory:" + system + ", unusable memory:" + unusable);
        return MemoryUnit.bytes(unreservedBytes);
    }

    public MemoryUnit getUnusableMemory() {
        return this.hostInformation.getTotalMemory().minus(this.workerRuntimeInformation.getUsableMemory());
    }

    public MemoryUnit getFreeSpaceWorkingDirectory() {
        return this.workerRuntimeInformation.getFreeSpaceWorkingDirectory();
    }

    public MemoryUnit getFreeSpaceTemporaryDir() {
        return this.workerRuntimeInformation.getFreeSpaceTempFolder();
    }

    public boolean isUsercheckActive() {
        return this.workerRuntimeInformation.isUserLoginCheckEnabled();
    }

    public boolean isCgroupsAvailable() {
        return this.hostInformation.isCgroupsAvailable();
    }

    public LoadData getLoadData() {
        return this.workerRuntimeInformation.getLoadData();
    }

    public TimeInterval getUptime() {
        return this.workerRuntimeInformation.getUptime();
    }

    public Optional<String> getStartupHostname() {
        return this.workerStartupHostname;
    }

    public WorkerStatistic getWorkerStatistic() {
        return this.workerRuntimeInformation.getWorkerStatistic();
    }

    public String getFullDescription() {
        int usableProcessors;
        int processors;
        TableFormatter table = new TableFormatter(2, 4);
        ExternalWorkerState state = this.getWorkerState();
        table.addRow(new Object[]{"Worker state:", state});
        if (state == ExternalWorkerState.USER_OCCUPIED || state == ExternalWorkerState.AVAILABLE) {
            table.addRow("Processor Partitions:", this.executorState);
        }
        FileStorageInformation fileStorageInfo = this.workerRuntimeInformation.getWorkerFileStorageInformation();
        table.addRow("System:", this.hostInformation.getCPUName());
        if (this.workerStartupHostname.isPresent()) {
            table.addRow("Start-up address:", this.workerStartupHostname.get());
        }
        if ((processors = this.hostInformation.getNumberOfProcessors()) != (usableProcessors = processors - this.workerRuntimeInformation.getUnusableProcessors().size())) {
            table.addRow("Processors (Usable):", processors + " (" + usableProcessors + ")");
        } else {
            table.addRow("Processors:", processors);
        }
        table.addRow("Cores:", this.getCoreCount());
        table.addRow("Cgroups available:", this.hostInformation.isCgroupsAvailable() ? "yes" : "no");
        table.addRow("Memory:", this.hostInformation.getTotalMemory());
        table.addRow("Java version:", this.hostInformation.getJavaVersion());
        table.addRow("Program user:", this.hostInformation.getUser());
        table.addRow("Current users:", Joiner.on(", ").join(this.workerRuntimeInformation.getActiveUsers()));
        table.addRow("Running programs:", Joiner.on(", ").join(this.workerRuntimeInformation.getSortedActivePrograms()));
        table.addRow("Usercheck:", this.isUsercheckActive() ? "activated" : "deactivated");
        table.addRow("Worker Uptime:", this.getUptime());
        table.addRow("Load:", this.getLoadData());
        table.addRow("Free Memory:", this.workerRuntimeInformation.getFreeMemory());
        table.addRow("Stored Files:", fileStorageInfo.getNumberOfStoredFiles());
        table.addRow("Stored File Size:", fileStorageInfo.getStorageSize());
        table.addRow("Available space working dir:", this.workerRuntimeInformation.getFreeSpaceWorkingDirectory());
        table.addRow("Available space temp dir:", this.workerRuntimeInformation.getFreeSpaceTempFolder());
        table.addRow("Currently assigned runs:", this.executorState.getNumberOfPartitions());
        table.addRow("Reserved processors:", this.getNumberOfReservedProcessors());
        StringBuilder description = new StringBuilder();
        description.append(this.getWorkerHostname()).append(":\n");
        description.append(table.buildTable());
        return description.toString();
    }

    private int getCoreCount() {
        HashSet<Integer> cores = Sets.newHashSet();
        for (Processor processor : this.hostInformation.getProcessors()) {
            int coreSocketId = processor.getCoreId() | processor.getSocketId() << 16;
            cores.add(coreSocketId);
        }
        return cores.size();
    }

    public String toString() {
        String hostname = Strings.padEnd(this.getWorkerHostname(), 14, ' ');
        int maxStateLength = 0;
        for (ExternalWorkerState description : ExternalWorkerState.values()) {
            maxStateLength = Math.max(description.toString().length(), maxStateLength);
        }
        String stateDescription = Strings.padEnd(this.getWorkerState().toString(), maxStateLength + 1, ' ');
        return hostname + stateDescription + this.getSystemDescription();
    }
}

