/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.transportable.info.processors;

import com.google.common.base.Charsets;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.verifiercloud.global.util.system.SystemEnvironmentException;
import org.sosy_lab.verifiercloud.transportable.info.processors.Processor;
import org.sosy_lab.verifiercloud.transportable.info.processors.ProcessorParser;

public class NumaProcessorParser {
    private static final Path NODE_PATH = Paths.get("/sys/devices/system/node", new String[0]);
    private static final Path NODE_NUMBER_PATH = NODE_PATH.resolve("has_cpu");
    private static final Splitter CPU_RANGE_SPLITTER = Splitter.on(',');
    private static final Splitter NODE_NUMBER_SPLITTER = Splitter.on('-');

    public static boolean isNUMAsupportAvailable() {
        return Files.isReadable(NODE_PATH);
    }

    public static Map<Processor, Integer> parseProcessorNumaInfo() throws SystemEnvironmentException {
        int numberOfNodes;
        ImmutableMap.Builder<Processor, Integer> cpuNodeMapping = ImmutableMap.builder();
        Set<Processor> processors = ProcessorParser.parseProcessorInformation();
        if (!Files.isReadable(NODE_NUMBER_PATH)) {
            return Maps.asMap(processors, Functions.constant(0));
        }
        try {
            numberOfNodes = NumaProcessorParser.getNumerOfNodes();
        }
        catch (IOException e) {
            throw new SystemEnvironmentException("Cannot determine number of numa nodes.", e);
        }
        if (numberOfNodes == 1) {
            return Maps.asMap(processors, Functions.constant(0));
        }
        for (int nodeNumber = 0; nodeNumber < numberOfNodes; ++nodeNumber) {
            String cpuList = NumaProcessorParser.readCpuList(nodeNumber);
            List<String> cpuRangeToken = CPU_RANGE_SPLITTER.splitToList(cpuList);
            for (String cpuRange : cpuRangeToken) {
                int max;
                int min;
                List<String> cpuIdToken = NODE_NUMBER_SPLITTER.splitToList(cpuRange);
                if (cpuIdToken.size() == 1) {
                    max = min = Integer.parseInt(cpuIdToken.get(0));
                } else if (cpuIdToken.size() == 2) {
                    min = Integer.parseInt(cpuIdToken.get(0));
                    max = Integer.parseInt(cpuIdToken.get(1));
                } else {
                    throw new SystemEnvironmentException("Cannot parse NUMA node information: " + cpuList);
                }
                for (int processorId = min; processorId <= max; ++processorId) {
                    Processor processor = FluentIterable.from(processors).filter(new ProssorIdFilter(processorId)).first().get();
                    cpuNodeMapping.put(processor, nodeNumber);
                }
            }
        }
        return cpuNodeMapping.build();
    }

    private static String readCpuList(int nodeNumber) throws SystemEnvironmentException {
        Path cpuListPath = NODE_PATH.resolve("node" + nodeNumber).resolve("cpulist");
        try {
            List<String> cpuListLines = Files.readAllLines(cpuListPath, Charsets.UTF_8);
            assert (cpuListLines.size() == 1);
            return cpuListLines.get(0);
        }
        catch (IOException e) {
            throw new SystemEnvironmentException("Cannot read cpu list from " + cpuListPath, e);
        }
    }

    private static int getNumerOfNodes() throws IOException, SystemEnvironmentException {
        int numberOfNodes;
        List<String> memoryNodeLines = Files.readAllLines(NODE_NUMBER_PATH, Charsets.UTF_8);
        if (memoryNodeLines.isEmpty()) {
            return 1;
        }
        assert (memoryNodeLines.size() == 1) : memoryNodeLines;
        String memoryNodes = memoryNodeLines.get(0);
        List<String> nodeNumberTokens = NODE_NUMBER_SPLITTER.splitToList(memoryNodes);
        if (nodeNumberTokens.size() == 1 && nodeNumberTokens.get(0).equals("0")) {
            numberOfNodes = 1;
        } else if (nodeNumberTokens.size() == 2) {
            numberOfNodes = Integer.parseInt(nodeNumberTokens.get(1)) + 1;
        } else {
            throw new SystemEnvironmentException("Cannot parse NUMA node information: " + memoryNodeLines);
        }
        return numberOfNodes;
    }

    private static class ProssorIdFilter
    implements Predicate<Processor> {
        private final int processorId;

        public ProssorIdFilter(int processorId) {
            this.processorId = processorId;
        }

        @Override
        public boolean apply(Processor processor) {
            return processor.getProcessorId() == this.processorId;
        }
    }
}

