/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.transportable.info.processors;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class Processor
implements Serializable,
Comparable<Processor> {
    private static final long serialVersionUID = 4604136697029846580L;
    private static final int PROCESSOR_MASK = 65535;
    private static final int CORE_MASK = 0xFF0000;
    private static final int SOCKET_MASK = -16777216;
    private final int processor;

    public Processor(int processorId, int coreId, int socketId) {
        Preconditions.checkArgument((processorId & 0xFFFF) == processorId, "ProcessorId unexpected: %s", processorId);
        Preconditions.checkArgument(coreId >= 0);
        Preconditions.checkArgument(coreId <= 256);
        Preconditions.checkArgument(socketId >= 0);
        Preconditions.checkArgument(coreId <= 256);
        this.processor = processorId | coreId << 16 | socketId << 24;
    }

    public int getProcessorId() {
        return this.processor & 0xFFFF;
    }

    public int getCoreId() {
        return (this.processor & 0xFF0000) >> 16;
    }

    public int getSocketId() {
        return (this.processor & 0xFF000000) >> 24;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Processor)) {
            return false;
        }
        Processor that = (Processor)other;
        return this.processor == that.processor;
    }

    public int hashCode() {
        return this.processor;
    }

    public String toString() {
        return String.format("processor: %d; core id: %d; socket id: %d", this.getProcessorId(), this.getCoreId(), this.getSocketId());
    }

    @Override
    public int compareTo(Processor o) {
        return Integer.compare(this.processor, o.processor);
    }
}

