/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.transportable.info.worker;

import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import java.io.Serializable;
import java.util.Collections;
import javax.annotation.concurrent.Immutable;
import org.sosy_lab.verifiercloud.transportable.info.worker.WorkerPartitionInformation;

@Immutable
public final class ExecutorState
implements Serializable {
    private static final long serialVersionUID = 869442275309477207L;
    private final ImmutableList<WorkerPartitionInformation> sortedPartitions;

    public static ExecutorState emptyExecutorState() {
        return new ExecutorState(Collections.emptyList());
    }

    public ExecutorState(Iterable<WorkerPartitionInformation> partitions) {
        this.sortedPartitions = Ordering.natural().immutableSortedCopy(partitions);
    }

    public ImmutableCollection<WorkerPartitionInformation> getPartitions() {
        return this.sortedPartitions;
    }

    public int getNumberOfPartitions() {
        return this.sortedPartitions.size();
    }

    public String toString() {
        if (this.sortedPartitions.isEmpty()) {
            return "{ }";
        }
        FluentIterable<String> stringStates = FluentIterable.from(this.sortedPartitions).transform(Functions.toStringFunction());
        StringBuilder str = new StringBuilder();
        str.append('{');
        Joiner.on(", ").appendTo(str, (Iterable<?>)stringStates);
        str.append('}');
        return str.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ExecutorState)) {
            return false;
        }
        ExecutorState that = (ExecutorState)other;
        return this.sortedPartitions.equals(that.sortedPartitions);
    }

    public int hashCode() {
        return this.sortedPartitions.hashCode();
    }
}

