/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.transportable.info.worker;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class LoadData
implements Serializable {
    private static final long serialVersionUID = 7665500079981851458L;
    private static final String FORMAT = "%.2f";
    private final float load1Minute;
    private final float load5Minutes;
    private final float load15Minutes;

    public static LoadData invalidLoadData() {
        return new LoadData(0.0f, 0.0f, 0.0f);
    }

    public LoadData(float load1Minute, float load5Minutes, float load15Minutes) {
        Preconditions.checkArgument(load1Minute >= 0.0f);
        Preconditions.checkArgument(load5Minutes >= 0.0f);
        Preconditions.checkArgument(load15Minutes >= 0.0f);
        this.load1Minute = load1Minute;
        this.load5Minutes = load5Minutes;
        this.load15Minutes = load15Minutes;
    }

    public String getLoad1MinuteString() {
        return String.format(FORMAT, Float.valueOf(this.load1Minute));
    }

    public float getLoad1Minute() {
        return this.load1Minute;
    }

    public String getLoad5MinutesString() {
        return String.format(FORMAT, Float.valueOf(this.load5Minutes));
    }

    public float getLoad5Minutes() {
        return this.load5Minutes;
    }

    public String getLoad15MinutesString() {
        return String.format(FORMAT, Float.valueOf(this.load15Minutes));
    }

    public float getLoad15Minutes() {
        return this.load15Minutes;
    }

    public String toString() {
        return Joiner.on(" ").join(this.getLoad1MinuteString(), this.getLoad5MinutesString(), this.getLoad15MinutesString());
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.load1Minute), Float.valueOf(this.load5Minutes), Float.valueOf(this.load15Minutes));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LoadData that = (LoadData)obj;
        return this.getLoad1MinuteString().equals(that.getLoad1MinuteString()) && this.getLoad5MinutesString().equals(that.getLoad5MinutesString()) && this.getLoad15MinutesString().equals(that.getLoad15MinutesString());
    }
}

