/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.transportable.info.worker;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.sosy_lab.verifiercloud.transportable.info.worker.WorkerPartitionState;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;

@Immutable
public final class WorkerPartitionInformation
implements Serializable,
Comparable<WorkerPartitionInformation> {
    private static final long serialVersionUID = 4241337300558084962L;
    private final int id;
    private final WorkerPartitionState state;
    private final Map<Integer, MemoryUnit> reservedMemory;
    private final int processors;
    private final String runCollectionId;

    public WorkerPartitionInformation(int id, WorkerPartitionState state, Map<Integer, MemoryUnit> reservedMemory, int processors, String runCollectionId) {
        this.id = id;
        this.state = Preconditions.checkNotNull(state);
        this.reservedMemory = Preconditions.checkNotNull(reservedMemory);
        Preconditions.checkArgument(processors > 0, "Number of assigned processors is %s.", processors);
        this.processors = processors;
        this.runCollectionId = runCollectionId;
    }

    public WorkerPartitionState getState() {
        return this.state;
    }

    public Map<Integer, MemoryUnit> getReservedMemory() {
        return this.reservedMemory;
    }

    public int getNumberOfProcessors() {
        return this.processors;
    }

    public String getRunCollectionId() {
        return this.runCollectionId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof WorkerPartitionInformation)) {
            return false;
        }
        WorkerPartitionInformation that = (WorkerPartitionInformation)other;
        return this.id == that.id && this.state.equals((Object)that.state) && this.reservedMemory.equals(that.reservedMemory) && this.processors == that.processors && this.runCollectionId.equals(that.runCollectionId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.state, this.reservedMemory, this.processors, this.runCollectionId});
    }

    public String toString() {
        return this.id + ":" + (Object)((Object)this.state);
    }

    @Override
    public int compareTo(WorkerPartitionInformation that) {
        return this.id - that.id;
    }
}

