/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.transportable.info.worker;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.sosy_lab.verifiercloud.transportable.info.FileStorageInformation;
import org.sosy_lab.verifiercloud.transportable.info.processors.Processor;
import org.sosy_lab.verifiercloud.transportable.info.worker.LoadData;
import org.sosy_lab.verifiercloud.transportable.info.worker.WorkerState;
import org.sosy_lab.verifiercloud.transportable.info.worker.WorkerStatistic;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;
import org.sosy_lab.verifiercloud.transportable.units.time.TimeInterval;

@Immutable
public final class WorkerRuntimeInformation
implements Serializable {
    private static final long serialVersionUID = 4L;
    private final WorkerState state;
    private final MemoryUnit freeSpaceWorkingDirectory;
    private final MemoryUnit freeSpaceTempFolder;
    private final LoadData loadData;
    private final TimeInterval uptime;
    private final boolean userLoginCheckEnabled;
    private final ImmutableList<String> activeUsers;
    private final ImmutableList<String> activePrograms;
    private final FileStorageInformation fileStorageInformation;
    private final ImmutableSet<Processor> unusableProcessors;
    private final MemoryUnit usableMemory;
    private final MemoryUnit freeMemory;
    private final ImmutableMap<Integer, MemoryUnit> freeNumaMemory;
    private final WorkerStatistic workerStatistic;

    public WorkerRuntimeInformation(WorkerState state, MemoryUnit freeSpaceWorkingDirectory, MemoryUnit freeSpaceTempFolder, LoadData loadData, MemoryUnit freeMemory, Map<Integer, MemoryUnit> freeNumaMemory, TimeInterval uptime, boolean userLoginCheckEnabled, Collection<String> activeUsers, Collection<String> activePrograms, FileStorageInformation fileStorageInformation, Set<Processor> unusableProcessors, MemoryUnit usableMemory, WorkerStatistic workerStatistic) {
        this.state = Preconditions.checkNotNull(state);
        this.freeSpaceWorkingDirectory = Preconditions.checkNotNull(freeSpaceWorkingDirectory);
        this.freeSpaceTempFolder = Preconditions.checkNotNull(freeSpaceTempFolder);
        this.loadData = Preconditions.checkNotNull(loadData);
        this.uptime = Preconditions.checkNotNull(uptime);
        this.userLoginCheckEnabled = userLoginCheckEnabled;
        this.activeUsers = Ordering.natural().immutableSortedCopy(activeUsers);
        this.activePrograms = Ordering.natural().immutableSortedCopy(activePrograms);
        this.fileStorageInformation = Preconditions.checkNotNull(fileStorageInformation);
        this.freeMemory = Preconditions.checkNotNull(freeMemory);
        Preconditions.checkArgument(!freeNumaMemory.isEmpty());
        this.freeNumaMemory = ImmutableMap.copyOf(freeNumaMemory);
        this.unusableProcessors = ImmutableSet.copyOf(unusableProcessors);
        this.usableMemory = Preconditions.checkNotNull(usableMemory);
        this.workerStatistic = Preconditions.checkNotNull(workerStatistic);
    }

    public ImmutableCollection<String> getActiveUsers() {
        return this.activeUsers;
    }

    public ImmutableList<String> getSortedActivePrograms() {
        return this.activePrograms;
    }

    public boolean isUserLoginCheckEnabled() {
        return this.userLoginCheckEnabled;
    }

    public TimeInterval getUptime() {
        return this.uptime;
    }

    public LoadData getLoadData() {
        return this.loadData;
    }

    public MemoryUnit getFreeMemory() {
        return this.freeMemory;
    }

    public Map<Integer, MemoryUnit> getFreeNumaMemory() {
        return this.freeNumaMemory;
    }

    public FileStorageInformation getWorkerFileStorageInformation() {
        return this.fileStorageInformation;
    }

    public WorkerState getState() {
        return this.state;
    }

    public WorkerStatistic getWorkerStatistic() {
        return this.workerStatistic;
    }

    public ImmutableSet<Processor> getUnusableProcessors() {
        return this.unusableProcessors;
    }

    public MemoryUnit getUsableMemory() {
        return this.usableMemory;
    }

    public MemoryUnit getFreeSpaceWorkingDirectory() {
        return this.freeSpaceWorkingDirectory;
    }

    public MemoryUnit getFreeSpaceTempFolder() {
        return this.freeSpaceTempFolder;
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(this).add("freeMemory", this.freeMemory).add("freeNumaMemory", this.freeNumaMemory).add("freeSpaceTempFolder", this.freeSpaceTempFolder).add("freeSpaceWorkingDirectory", this.freeSpaceWorkingDirectory).add("load", this.loadData).add("state", (Object)this.state).add("unusableProcessors", this.unusableProcessors).add("usableMemory", this.usableMemory);
        if (this.userLoginCheckEnabled) {
            helper.add("activePrograms", this.activePrograms);
            helper.add("activeUsers", this.activeUsers);
        }
        return helper.toString();
    }
}

