/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.transportable.info.worker;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import javax.annotation.concurrent.Immutable;
import org.sosy_lab.verifiercloud.transportable.info.worker.LoadData;

@Immutable
public class WorkerStatistic
implements Serializable {
    private static final long serialVersionUID = -8584099688382894395L;
    private final double overallLoad;
    private final double relativeUserOccupiedTime;
    private final double relativeIdleTime;
    private final LoadData cloudLoadData;

    public WorkerStatistic(double overallLoad, double relativeUserOccupiedTime, double relativeIdleTime, LoadData cloudLoadData) {
        Preconditions.checkArgument(overallLoad >= 0.0 && overallLoad <= 1.0);
        Preconditions.checkArgument(relativeUserOccupiedTime >= 0.0 && relativeUserOccupiedTime <= 1.0);
        Preconditions.checkArgument(relativeIdleTime >= 0.0 && relativeIdleTime <= 1.0);
        this.overallLoad = overallLoad;
        this.relativeUserOccupiedTime = relativeUserOccupiedTime;
        this.relativeIdleTime = relativeIdleTime;
        this.cloudLoadData = Preconditions.checkNotNull(cloudLoadData);
    }

    public double getOverallLoad() {
        return this.overallLoad;
    }

    public double getRelativeUserOccupiedTime() {
        return this.relativeUserOccupiedTime;
    }

    public double getRelativeIdleTime() {
        return this.relativeIdleTime;
    }

    public LoadData getCloudLoadData() {
        return this.cloudLoadData;
    }
}

