/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.transportable.info.worker.constant;

import com.google.common.base.Preconditions;
import com.google.common.base.StandardSystemProperty;
import com.google.common.base.Strings;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.sosy_lab.verifiercloud.transportable.info.processors.Processor;
import org.sosy_lab.verifiercloud.transportable.info.worker.constant.HostInformation;
import org.sosy_lab.verifiercloud.transportable.units.frequency.Frequency;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;

@Immutable
public class DefaultHostInformation
implements HostInformation {
    private static final long serialVersionUID = 5L;
    private final String user;
    private final String hostname;
    private final String javaVersion = StandardSystemProperty.JAVA_VERSION.value();
    private final String osName = StandardSystemProperty.OS_NAME.value();
    private final String osVersion = StandardSystemProperty.OS_VERSION.value();
    private final String cpuModel;
    private final ImmutableSet<Processor> processors;
    private final ImmutableMap<Processor, Integer> processorNumaNodeMapping;
    private final Frequency cpuFrequency;
    private final MemoryUnit totalMemory;
    private final Map<Integer, MemoryUnit> totalNumaMemory;
    private final boolean isCgroupsAvailable;

    public DefaultHostInformation(String hostname, String user, String cpuModel, Set<Processor> processors, Map<Processor, Integer> processorNumaNodeMapping, Frequency cpuFrequency, MemoryUnit totalMemory, Map<Integer, MemoryUnit> totalNumaMemory, boolean isCgroupsAvailable) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(hostname));
        this.hostname = hostname;
        Preconditions.checkArgument(!Strings.isNullOrEmpty(user));
        this.user = user;
        Preconditions.checkArgument(!Strings.isNullOrEmpty(cpuModel));
        this.cpuModel = cpuModel;
        Preconditions.checkArgument(!processors.isEmpty());
        this.processors = ImmutableSet.copyOf(processors);
        Preconditions.checkArgument(!processorNumaNodeMapping.isEmpty());
        this.processorNumaNodeMapping = ImmutableMap.copyOf(processorNumaNodeMapping);
        this.cpuFrequency = Preconditions.checkNotNull(cpuFrequency);
        Preconditions.checkArgument(!totalNumaMemory.isEmpty());
        this.totalNumaMemory = Preconditions.checkNotNull(totalNumaMemory);
        this.totalMemory = Preconditions.checkNotNull(totalMemory);
        this.isCgroupsAvailable = isCgroupsAvailable;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public String getJavaVersion() {
        return this.javaVersion;
    }

    @Override
    public String getOsName() {
        return this.osName;
    }

    @Override
    public String getOsVersion() {
        return this.osVersion;
    }

    @Override
    public String getCPUName() {
        return this.cpuModel;
    }

    @Override
    public int getNumberOfProcessors() {
        return this.processors.size();
    }

    @Override
    public ImmutableSet<Processor> getProcessors() {
        return this.processors;
    }

    @Override
    public Map<Processor, Integer> getProcessorNumaNodeMapping() {
        return this.processorNumaNodeMapping;
    }

    @Override
    public MemoryUnit getTotalMemory() {
        return this.totalMemory;
    }

    @Override
    public Map<Integer, MemoryUnit> getTotalNumaMemory() {
        return this.totalNumaMemory;
    }

    @Override
    public Frequency getCPUFrequency() {
        return this.cpuFrequency;
    }

    @Override
    public boolean isCgroupsAvailable() {
        return this.isCgroupsAvailable;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DefaultHostInformation)) {
            return false;
        }
        return this.compareTo((DefaultHostInformation)other) == 0;
    }

    @Override
    public int compareTo(HostInformation that) {
        return ComparisonChain.start().compare((Comparable<?>)((Object)this.getUser()), (Comparable<?>)((Object)that.getUser())).compare((Comparable<?>)((Object)this.getHostname()), (Comparable<?>)((Object)that.getHostname())).compare((Comparable<?>)((Object)this.getJavaVersion()), (Comparable<?>)((Object)that.getJavaVersion())).compare((Comparable<?>)((Object)this.getOsName()), (Comparable<?>)((Object)that.getOsName())).compare((Comparable<?>)((Object)this.getOsVersion()), (Comparable<?>)((Object)that.getOsVersion())).compare((Comparable<?>)((Object)this.getCPUName()), (Comparable<?>)((Object)that.getCPUName())).compare(this.getCPUFrequency(), that.getCPUFrequency()).compare(this.getNumberOfProcessors(), that.getNumberOfProcessors()).compare(this.getTotalMemory(), that.getTotalMemory()).compare(this.getTotalNumaMemory(), that.getTotalNumaMemory(), Ordering.usingToString()).compareTrueFirst(this.isCgroupsAvailable(), that.isCgroupsAvailable()).result();
    }

    public int hashCode() {
        return Objects.hash(this.user, this.hostname, this.javaVersion, this.cpuModel, this.cpuFrequency, this.processors, this.totalMemory, this.totalNumaMemory, this.isCgroupsAvailable);
    }
}

