/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.transportable.run;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.FileAtRelativePath;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.FileHierarchy;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.RelativePath;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.string_based.DefaultFileHierarchy;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.string_based.StringRelativePath;
import org.sosy_lab.verifiercloud.transportable.run.Run;
import org.sosy_lab.verifiercloud.transportable.run.RunWithFiles;
import org.sosy_lab.verifiercloud.transportable.run.constraints.limitations.Limitations;
import org.sosy_lab.verifiercloud.transportable.run.constraints.limitations.LimitationsBuilder;
import org.sosy_lab.verifiercloud.transportable.run.filters.CompletePathFileFilter;
import org.sosy_lab.verifiercloud.transportable.run.filters.DisjunctiveFileFilter;
import org.sosy_lab.verifiercloud.transportable.run.filters.FileFilter;
import org.sosy_lab.verifiercloud.transportable.run.filters.NoneFileFilter;
import org.sosy_lab.verifiercloud.transportable.units.time.TimeInterval;

public final class RunBuilder {
    private final List<String> command;
    private FileHierarchy files = new DefaultFileHierarchy(new ArrayList<FileAtRelativePath>());
    private Limitations limitations = LimitationsBuilder.from(TimeInterval.hours(1L)).build();
    private FileFilter outputFilePattern = new NoneFileFilter();
    private RelativePath executionPath = StringRelativePath.from(".");
    private Optional<String> description = Optional.absent();
    private boolean storeResultOnMaster;
    private RelativePath workerResultFile = StringRelativePath.from("./workerResultFile.log");

    public static RunBuilder forCommand(List<String> command) {
        return new RunBuilder(command);
    }

    private RunBuilder(List<String> command) {
        this.command = Preconditions.checkNotNull(command);
    }

    public RunBuilder setWorkerResultFile(RelativePath workerResultFile) {
        this.workerResultFile = workerResultFile;
        return this;
    }

    public RunBuilder setDescription(String description) {
        this.description = Optional.of(description);
        return this;
    }

    public RunBuilder addFiles(FileHierarchy fileHierarchy) {
        this.files = Preconditions.checkNotNull(fileHierarchy);
        return this;
    }

    public RunBuilder setLimitations(Limitations limitations) {
        this.limitations = Preconditions.checkNotNull(limitations);
        return this;
    }

    public RunBuilder setOutputFilePattern(FileFilter outputFilePattern) {
        this.outputFilePattern = Preconditions.checkNotNull(outputFilePattern);
        return this;
    }

    public RunBuilder setExecutionPath(RelativePath executionPath) {
        this.executionPath = Preconditions.checkNotNull(executionPath);
        return this;
    }

    public RunBuilder storeResultOnMaster() {
        this.storeResultOnMaster = true;
        return this;
    }

    public Run build() {
        ImmutableList<FileFilter> fileFilters = ImmutableList.of(new CompletePathFileFilter(this.workerResultFile), this.outputFilePattern);
        DisjunctiveFileFilter outputAndWorkerResultFileFilter = new DisjunctiveFileFilter(fileFilters);
        return new RunWithFiles(this.command, this.workerResultFile, this.files, this.limitations, outputAndWorkerResultFileFilter, this.executionPath, this.description, this.storeResultOnMaster);
    }
}

