/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.transportable.run;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collection;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.FileAtRelativePath;
import org.sosy_lab.verifiercloud.transportable.filecontent.FileContent;
import org.sosy_lab.verifiercloud.transportable.info.worker.constant.HostInformation;
import org.sosy_lab.verifiercloud.transportable.run.Run;
import org.sosy_lab.verifiercloud.transportable.units.energy.Energy;
import org.sosy_lab.verifiercloud.transportable.units.time.TimeInterval;

@Immutable
public class RunResult
implements Serializable {
    private static final long serialVersionUID = 17L;
    private final Run run;
    private final int exitCode;
    private final TimeInterval outerWallTime;
    private final TimeInterval wallTime;
    private final ImmutableMap<String, String> runInformation;
    private final FileContent warnings;
    private final ImmutableList<FileAtRelativePath> resultFiles;
    private final ImmutableList<FileAtRelativePath> allNewFiles;
    private final HostInformation workerHost;
    @Nullable
    private final Energy energy;
    private final boolean wasKilled;

    public RunResult(Run run, int exitCode, TimeInterval outerWallTime, TimeInterval wallTime, ImmutableMap<String, String> runInformation, FileContent warnings, Iterable<FileAtRelativePath> allNewFiles, HostInformation workerHost) {
        this(run, exitCode, outerWallTime, wallTime, runInformation, warnings, Lists.newArrayList(), allNewFiles, Optional.absent(), workerHost, false);
    }

    public RunResult(Run run, int exitCode, TimeInterval outerWalltime, TimeInterval wallTime, ImmutableMap<String, String> runInformation, FileContent warnings, Collection<FileAtRelativePath> resultFiles, Iterable<FileAtRelativePath> allNewFiles, Optional<Energy> energy, HostInformation workerHost, boolean wasKilled) {
        this.run = Preconditions.checkNotNull(run);
        Preconditions.checkArgument(exitCode >= 0 && exitCode < 65536, "%s is not a valid program exit code.", exitCode);
        this.exitCode = exitCode;
        this.outerWallTime = Preconditions.checkNotNull(outerWalltime);
        this.wallTime = Preconditions.checkNotNull(wallTime);
        this.runInformation = Preconditions.checkNotNull(runInformation);
        this.warnings = Preconditions.checkNotNull(warnings);
        this.resultFiles = ImmutableList.copyOf(resultFiles);
        this.allNewFiles = ImmutableList.copyOf(allNewFiles);
        this.energy = energy.orNull();
        this.workerHost = Preconditions.checkNotNull(workerHost);
        this.wasKilled = wasKilled;
    }

    public Run getRun() {
        return this.run;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public FileContent getWarnings() {
        return this.warnings;
    }

    public ImmutableCollection<FileAtRelativePath> getResultFiles() {
        return this.resultFiles;
    }

    public HostInformation getHostInformation() {
        return this.workerHost;
    }

    public TimeInterval getOuterWallTime() {
        return this.outerWallTime;
    }

    public TimeInterval getWallTime() {
        return this.wallTime;
    }

    public Optional<Energy> getEnergy() {
        return Optional.fromNullable(this.energy);
    }

    public ImmutableMap<String, String> getRunInformation() {
        return this.runInformation;
    }

    public Iterable<FileAtRelativePath> getAllNewFiles() {
        return this.allNewFiles;
    }

    public boolean wasKilled() {
        return this.wasKilled;
    }

    public String toString() {
        return "ResultFor" + this.run.toString();
    }
}

