/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.transportable.run;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.FileAtRelativePath;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.FileHierarchy;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.RelativePath;
import org.sosy_lab.verifiercloud.transportable.run.Run;
import org.sosy_lab.verifiercloud.transportable.run.constraints.limitations.Limitations;
import org.sosy_lab.verifiercloud.transportable.run.filters.FileFilter;

@Immutable
public final class RunWithFiles
implements Run {
    private static final long serialVersionUID = 16L;
    private static final Cache<UUID, RunWithFiles> cache = CacheBuilder.newBuilder().weakValues().build();
    private static final AtomicInteger cacheReadCounter = new AtomicInteger(0);
    private static final int CACHE_CLEANUP_INTERVAL = 1000;
    private final UUID id;
    @Nullable
    private final String description;
    private final ImmutableList<String> command;
    private final RelativePath workerResultFile;
    private final RelativePath executionPath;
    private final FileHierarchy files;
    private final Limitations limitations;
    private final FileFilter fileFilter;
    private final boolean storeResultsOnMaster;

    RunWithFiles(List<String> command, RelativePath workerResultFile, FileHierarchy files, Limitations limitations, FileFilter outputFileFilter, RelativePath executionPath, Optional<String> description, boolean storeResultsOnMaster) {
        Preconditions.checkNotNull(command);
        Preconditions.checkArgument(!command.isEmpty(), "Empty command");
        Preconditions.checkArgument(!FluentIterable.from(command).anyMatch(Predicates.or(Predicates.equalTo(""), Predicates.isNull())), "Empty command token: " + command);
        this.command = ImmutableList.copyOf(command);
        this.workerResultFile = Preconditions.checkNotNull(workerResultFile);
        this.limitations = Preconditions.checkNotNull(limitations);
        this.fileFilter = Preconditions.checkNotNull(outputFileFilter);
        Preconditions.checkNotNull(files);
        this.files = files;
        this.id = UUID.randomUUID();
        this.executionPath = Preconditions.checkNotNull(executionPath);
        Preconditions.checkArgument(executionPath.isChild(), "Can not execute program in non-child directory: %s", executionPath);
        this.checkRelativePathIsNotAKnownFile(files, executionPath);
        this.description = description.orNull();
        this.storeResultsOnMaster = storeResultsOnMaster;
    }

    @Override
    public String getUniqueSecureId() {
        return this.id.toString();
    }

    @Override
    public Optional<String> getOptionalDescription() {
        return Optional.fromNullable(this.description);
    }

    private void checkRelativePathIsNotAKnownFile(Iterable<FileAtRelativePath> files, RelativePath directoryPath) {
        for (FileAtRelativePath file : files) {
            RelativePath relativeFilePath = file.getRelativePath();
            if (!relativeFilePath.equals(directoryPath)) continue;
            throw new RuntimeException("Path is both used a file path and execution path: " + directoryPath);
        }
    }

    @Override
    public List<String> getCommand() {
        return this.command;
    }

    @Override
    public RelativePath getWorkerResultFile() {
        return this.workerResultFile;
    }

    @Override
    public RelativePath getRelativeProgramWorkingDirectory() {
        return this.executionPath;
    }

    @Override
    public FileHierarchy getFileHierarchy() {
        return this.files;
    }

    @Override
    public Limitations getLimitations() {
        return this.limitations;
    }

    @Override
    public FileFilter getOutputFilePattern() {
        return this.fileFilter;
    }

    @Override
    public boolean storeResultOnMaster() {
        return this.storeResultsOnMaster;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return true;
        }
        if (other.getClass() != RunWithFiles.class) {
            return false;
        }
        RunWithFiles that = (RunWithFiles)other;
        return this.id.equals(that.id);
    }

    @Override
    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public String toString() {
        return "Run[" + this.id + "]";
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        cache.put(this.id, this);
        stream.defaultWriteObject();
    }

    private Object readResolve() throws ObjectStreamException {
        RunWithFiles runFromCache = cache.getIfPresent(this.id);
        if (cacheReadCounter.incrementAndGet() == 1000) {
            cacheReadCounter.set(0);
            cache.cleanUp();
        }
        if (runFromCache != null) {
            return runFromCache;
        }
        return this;
    }
}

