/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.transportable.run.constraints.limitations;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.Immutable;
import org.sosy_lab.verifiercloud.transportable.run.constraints.limitations.Limitations;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;
import org.sosy_lab.verifiercloud.transportable.units.time.TimeInterval;

@Immutable
public class DefaultLimitations
implements Limitations {
    private static final long serialVersionUID = 4473007917170783964L;
    private final TimeInterval timeLimit;
    private final Optional<MemoryUnit> memoryLimit;
    private final Optional<Integer> processorLimit;

    DefaultLimitations(TimeInterval timeLimitations, Optional<MemoryUnit> memoryLimitations, Optional<Integer> processorLimit) {
        this.timeLimit = Preconditions.checkNotNull(timeLimitations);
        this.memoryLimit = Preconditions.checkNotNull(memoryLimitations);
        this.processorLimit = Preconditions.checkNotNull(processorLimit);
    }

    @Override
    public TimeInterval getTimeLimit() {
        return this.timeLimit;
    }

    @Override
    public Optional<MemoryUnit> getMemoryLimit() {
        return this.memoryLimit;
    }

    @Override
    public Optional<Integer> getProcessorLimit() {
        return this.processorLimit;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Limitations)) {
            return false;
        }
        Limitations that = (Limitations)other;
        return this.getMemoryLimit().equals(that.getMemoryLimit()) && this.getTimeLimit().equals(that.getTimeLimit());
    }

    public int hashCode() {
        return Objects.hashCode(this.timeLimit, this.memoryLimit);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(DefaultLimitations.class.getSimpleName());
        builder.append('[').append(this.timeLimit);
        if (this.memoryLimit.isPresent()) {
            builder.append(", ").append(this.memoryLimit.get());
        }
        if (this.processorLimit.isPresent()) {
            builder.append(", ").append(this.processorLimit.get()).append(" cpu cores");
        }
        builder.append(']');
        return builder.toString();
    }
}

