/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.transportable.run.constraints.limitations;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import org.sosy_lab.verifiercloud.transportable.run.constraints.limitations.DefaultLimitations;
import org.sosy_lab.verifiercloud.transportable.run.constraints.limitations.Limitations;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;
import org.sosy_lab.verifiercloud.transportable.units.time.TimeInterval;

public class LimitationsBuilder {
    private TimeInterval timeLimit;
    private Optional<MemoryUnit> memoryLimit;
    private Optional<Integer> coreLimit;

    private LimitationsBuilder(TimeInterval timeLimit) {
        this.timeLimit = timeLimit;
        this.memoryLimit = Optional.absent();
        this.coreLimit = Optional.absent();
    }

    private LimitationsBuilder(Limitations limitations) {
        this.timeLimit = limitations.getTimeLimit();
        this.memoryLimit = limitations.getMemoryLimit();
        this.coreLimit = limitations.getProcessorLimit();
    }

    public static LimitationsBuilder from(TimeInterval timeLimit) {
        return new LimitationsBuilder(Preconditions.checkNotNull(timeLimit));
    }

    public static LimitationsBuilder from(Limitations limitations) {
        return new LimitationsBuilder(Preconditions.checkNotNull(limitations));
    }

    public LimitationsBuilder setTimeLimit(TimeInterval timeLimit) {
        this.timeLimit = Preconditions.checkNotNull(timeLimit);
        return this;
    }

    public LimitationsBuilder setMemoryLimit(MemoryUnit memoryLimit) {
        this.memoryLimit = Optional.of(Preconditions.checkNotNull(memoryLimit));
        return this;
    }

    public LimitationsBuilder setCoreLimit(int coreLimit) {
        this.coreLimit = Optional.of(Preconditions.checkNotNull(coreLimit));
        return this;
    }

    public Limitations build() {
        return new DefaultLimitations(this.timeLimit, this.memoryLimit, this.coreLimit);
    }
}

