/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.transportable.run.constraints.requirements;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.concurrent.Immutable;
import org.sosy_lab.verifiercloud.global.logging.Logger;
import org.sosy_lab.verifiercloud.transportable.info.master.ExternalWorkerState;
import org.sosy_lab.verifiercloud.transportable.info.master.WorkerSummary;
import org.sosy_lab.verifiercloud.transportable.run.constraints.requirements.DefaultScheduledRequirements;
import org.sosy_lab.verifiercloud.transportable.run.constraints.requirements.Requirements;
import org.sosy_lab.verifiercloud.transportable.run.constraints.requirements.ScheduledRequirements;

@Immutable
public abstract class AbstractRequirements
implements Requirements {
    private static final long serialVersionUID = 3990316515876935641L;
    private static final Function<WorkerSummary, String> WORKER_TO_CPU_MODEL = new Function<WorkerSummary, String>(){

        @Override
        @SuppressFBWarnings(value={"NP"})
        public String apply(WorkerSummary worker) {
            return worker.getCPUName();
        }
    };
    private static final Predicate<WorkerSummary> WORKER_IS_AVAILABLE = new Predicate<WorkerSummary>(){

        @Override
        @SuppressFBWarnings(value={"NP"})
        public boolean apply(WorkerSummary worker) {
            return worker.getWorkerState().equals((Object)ExternalWorkerState.AVAILABLE);
        }
    };

    @Override
    public ScheduledRequirements toScheduledRequirements(List<WorkerSummary> workers, Logger logger) {
        Optional<String> CPURequirement = this.chooseCpuModel(workers, logger);
        return new DefaultScheduledRequirements(this.getMemoryRequirements(), this.getProcessorRequirements(), CPURequirement, this.requireCgroups());
    }

    private Optional<String> chooseCpuModel(List<WorkerSummary> workers, Logger logger) {
        Set<String> availableCpus = this.getFilteredCpus(workers, WORKER_IS_AVAILABLE);
        Optional<String> cpuModel = this.chooseCpuModel(availableCpus);
        if (!cpuModel.isPresent()) {
            Set<String> allCpus = this.getFilteredCpus(workers, Predicates.alwaysTrue());
            cpuModel = this.chooseCpuModel(allCpus);
        }
        if (!cpuModel.isPresent()) {
            cpuModel = FluentIterable.from(this.getCPURequirements()).first();
        }
        logger.logf(Level.INFO, "Given CPU models %s, using %s", this.getCPURequirements(), cpuModel.or("-"));
        return cpuModel;
    }

    private Optional<String> chooseCpuModel(Set<String> usableCpus) {
        for (String cpuRequirementToken : this.getCPURequirements()) {
            for (String availableCpu : usableCpus) {
                if (!availableCpu.contains(cpuRequirementToken)) continue;
                return Optional.of(cpuRequirementToken);
            }
        }
        return Optional.absent();
    }

    private Set<String> getFilteredCpus(List<WorkerSummary> workers, Predicate<WorkerSummary> filter) {
        return FluentIterable.from(workers).filter(filter).transform(WORKER_TO_CPU_MODEL).toSet();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Requirements)) {
            return false;
        }
        Requirements that = (Requirements)other;
        return this.getMemoryRequirements().equals(that.getMemoryRequirements()) && this.getProcessorRequirements() == that.getProcessorRequirements() && this.getCPURequirements().equals(that.getCPURequirements()) && this.requireCgroups() == that.requireCgroups();
    }

    public int hashCode() {
        return Objects.hash(this.getMemoryRequirements(), this.getProcessorRequirements(), this.getCPURequirements(), this.requireCgroups());
    }
}

