/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.transportable.run.constraints.requirements;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.sosy_lab.verifiercloud.master.workerside.functional_idioms.EnoughAvailablMemoryOnNodes;
import org.sosy_lab.verifiercloud.master.workerside.functional_idioms.EnoughAvailablProcessorsOnNodes;
import org.sosy_lab.verifiercloud.master.workerside.functional_idioms.ProcessorsToMaxCountPerSocket;
import org.sosy_lab.verifiercloud.master.workerside.functional_idioms.ProcessorsToSocketToNumOfProcessor;
import org.sosy_lab.verifiercloud.master.workerside.functional_idioms.SetSizeComparator;
import org.sosy_lab.verifiercloud.transportable.info.processors.Processor;
import org.sosy_lab.verifiercloud.transportable.info.worker.constant.HostInformation;
import org.sosy_lab.verifiercloud.transportable.run.constraints.requirements.AbstractRequirements;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;

@Immutable
public class DefaultRequirements
extends AbstractRequirements {
    private static final long serialVersionUID = -6992045644508047316L;
    private final Optional<MemoryUnit> memoryRequirements;
    private final int processorRequirements;
    private final List<String> cpuRequirements;
    private final boolean requireCgroups;

    DefaultRequirements(Optional<MemoryUnit> memoryRequirements, int processorRequirements, List<String> cpuRequirements, boolean requireCgroups) {
        Preconditions.checkArgument(processorRequirements > 0, "%s is not a valid number of processors.", processorRequirements);
        this.memoryRequirements = Preconditions.checkNotNull(memoryRequirements);
        this.processorRequirements = processorRequirements;
        this.cpuRequirements = ImmutableList.copyOf(cpuRequirements);
        this.requireCgroups = requireCgroups;
    }

    @Override
    public Optional<MemoryUnit> getMemoryRequirements() {
        return this.memoryRequirements;
    }

    @Override
    public int getProcessorRequirements() {
        return this.processorRequirements;
    }

    @Override
    public List<String> getCPURequirements() {
        return this.cpuRequirements;
    }

    @Override
    public boolean requireCgroups() {
        return this.requireCgroups;
    }

    @Override
    public boolean isSatisfiedBy(MemoryUnit availableMemory, Map<Integer, MemoryUnit> availableNumaMemory, Set<Processor> usableProcessors, int maxUsableCoreCountPerSocket, HostInformation hostInformation) {
        boolean isSatisfied;
        Preconditions.checkArgument(maxUsableCoreCountPerSocket > 0);
        Preconditions.checkNotNull(usableProcessors);
        Preconditions.checkNotNull(hostInformation);
        Preconditions.checkNotNull(availableMemory);
        String actualCpuName = hostInformation.getCPUName();
        boolean offersCgroups = hostInformation.isCgroupsAvailable();
        if (maxUsableCoreCountPerSocket >= this.processorRequirements) {
            int maxCoresPerSocket = ProcessorsToMaxCountPerSocket.INSTANCE.apply(usableProcessors);
            isSatisfied = maxCoresPerSocket >= this.processorRequirements;
        } else {
            boolean bl = isSatisfied = usableProcessors.size() >= this.processorRequirements;
        }
        if (isSatisfied && this.memoryRequirements.isPresent()) {
            isSatisfied = availableMemory.isGreaterEqualThan(this.memoryRequirements.get());
        }
        boolean isCpuModelSatisfied = false;
        for (String cpuName : this.cpuRequirements) {
            if (!actualCpuName.contains(cpuName)) continue;
            isCpuModelSatisfied = true;
            break;
        }
        if ((isSatisfied &= isCpuModelSatisfied) && this.requireCgroups) {
            isSatisfied = offersCgroups;
        }
        if (isSatisfied && this.memoryRequirements.isPresent() && availableNumaMemory.size() > 0) {
            Map<Integer, Integer> socketToUsabelProcessorCount = ProcessorsToSocketToNumOfProcessor.INSTANCE.apply(usableProcessors);
            Set<Set<Integer>> powerSetOfSockets = Sets.powerSet(socketToUsabelProcessorCount.keySet());
            ImmutableList<Set<Integer>> sortedUsableNodes = FluentIterable.from(powerSetOfSockets).filter(new EnoughAvailablProcessorsOnNodes(this.processorRequirements, socketToUsabelProcessorCount)).filter(new EnoughAvailablMemoryOnNodes(this.memoryRequirements.get(), availableNumaMemory)).toSortedList(SetSizeComparator.INSTANCE);
            isSatisfied = sortedUsableNodes.size() > 0;
        }
        return isSatisfied;
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(this).omitNullValues().add("processors", this.processorRequirements).add("memory", this.memoryRequirements.orNull());
        if (!this.cpuRequirements.isEmpty()) {
            helper.add("cpu", this.cpuRequirements);
        }
        return helper.add("cgroups", this.requireCgroups).toString();
    }
}

