/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.transportable.run.constraints.requirements;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.sosy_lab.verifiercloud.master.workerside.functional_idioms.EnoughAvailablMemoryOnNodes;
import org.sosy_lab.verifiercloud.master.workerside.functional_idioms.EnoughAvailablProcessorsOnNodes;
import org.sosy_lab.verifiercloud.master.workerside.functional_idioms.ProcessorsToMaxCountPerSocket;
import org.sosy_lab.verifiercloud.master.workerside.functional_idioms.ProcessorsToSocketToNumOfProcessor;
import org.sosy_lab.verifiercloud.master.workerside.functional_idioms.SetSizeComparator;
import org.sosy_lab.verifiercloud.transportable.info.processors.Processor;
import org.sosy_lab.verifiercloud.transportable.info.worker.constant.HostInformation;
import org.sosy_lab.verifiercloud.transportable.run.constraints.requirements.ScheduledRequirements;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;

public class DefaultScheduledRequirements
implements ScheduledRequirements {
    private static final long serialVersionUID = 1L;
    private final Optional<MemoryUnit> memoryRequirements;
    private final int processorRequirements;
    private final Optional<String> cpuRequirements;
    private final boolean requireCgroups;

    public DefaultScheduledRequirements(Optional<MemoryUnit> memoryRequirements, int processorRequirements, Optional<String> cpuRequirements, boolean requireCgroups) {
        Preconditions.checkArgument(processorRequirements > 0, "%s is not a valid number of processors.", processorRequirements);
        this.memoryRequirements = Preconditions.checkNotNull(memoryRequirements);
        this.processorRequirements = processorRequirements;
        this.cpuRequirements = Preconditions.checkNotNull(cpuRequirements);
        this.requireCgroups = requireCgroups;
    }

    @Override
    public int getProcessorRequirements() {
        return this.processorRequirements;
    }

    @Override
    public Optional<String> getCPURequirements() {
        return this.cpuRequirements;
    }

    @Override
    public Optional<MemoryUnit> getMemoryRequirements() {
        return this.memoryRequirements;
    }

    @Override
    public boolean requireCgroups() {
        return this.requireCgroups;
    }

    @Override
    public boolean isSatisfiedBy(MemoryUnit availableMemory, Map<Integer, MemoryUnit> availableNumaMemory, Set<Processor> usableProcessors, int maxUsableCoreCountPerSocket, HostInformation hostInformation) {
        boolean isSatisfied;
        Preconditions.checkArgument(maxUsableCoreCountPerSocket > 0);
        Preconditions.checkNotNull(usableProcessors);
        Preconditions.checkNotNull(hostInformation);
        Preconditions.checkNotNull(availableMemory);
        String actualCpuName = hostInformation.getCPUName();
        boolean offersCgroups = hostInformation.isCgroupsAvailable();
        if (maxUsableCoreCountPerSocket >= this.processorRequirements) {
            int maxCoresPerSocket = ProcessorsToMaxCountPerSocket.INSTANCE.apply(usableProcessors);
            isSatisfied = maxCoresPerSocket >= this.processorRequirements;
        } else {
            boolean bl = isSatisfied = usableProcessors.size() >= this.processorRequirements;
        }
        if (isSatisfied && this.memoryRequirements.isPresent()) {
            isSatisfied = availableMemory.isGreaterEqualThan(this.memoryRequirements.get());
        }
        if (isSatisfied && this.cpuRequirements.isPresent()) {
            isSatisfied = actualCpuName.contains(this.cpuRequirements.get());
        }
        if (isSatisfied && this.requireCgroups) {
            isSatisfied = offersCgroups;
        }
        if (isSatisfied && this.memoryRequirements.isPresent() && !availableNumaMemory.isEmpty()) {
            Map<Integer, Integer> socketToUsabelProcessorCount = ProcessorsToSocketToNumOfProcessor.INSTANCE.apply(usableProcessors);
            Set<Set<Integer>> powerSetOfSockets = Sets.powerSet(socketToUsabelProcessorCount.keySet());
            ImmutableList<Set<Integer>> sortedUsableNodes = FluentIterable.from(powerSetOfSockets).filter(new EnoughAvailablProcessorsOnNodes(this.processorRequirements, socketToUsabelProcessorCount)).filter(new EnoughAvailablMemoryOnNodes(this.memoryRequirements.get(), availableNumaMemory)).toSortedList(SetSizeComparator.INSTANCE);
            isSatisfied = maxUsableCoreCountPerSocket >= this.processorRequirements ? !sortedUsableNodes.isEmpty() && ((Set)sortedUsableNodes.get(0)).size() == 1 : !sortedUsableNodes.isEmpty();
        }
        return isSatisfied;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ScheduledRequirements)) {
            return false;
        }
        ScheduledRequirements that = (ScheduledRequirements)other;
        return this.getMemoryRequirements().equals(that.getMemoryRequirements()) && this.getProcessorRequirements() == that.getProcessorRequirements() && this.getCPURequirements().equals(that.getCPURequirements()) && this.requireCgroups() == that.requireCgroups();
    }

    public int hashCode() {
        return Objects.hash(this.getMemoryRequirements(), this.getProcessorRequirements(), this.getCPURequirements(), this.requireCgroups());
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("processors", this.processorRequirements).add("cpu", this.cpuRequirements.orNull()).add("memory", this.memoryRequirements.orNull()).add("cgroups", this.requireCgroups).toString();
    }
}

