/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.transportable.run.constraints.requirements;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.sosy_lab.verifiercloud.transportable.info.processors.Processor;
import org.sosy_lab.verifiercloud.transportable.info.worker.constant.HostInformation;
import org.sosy_lab.verifiercloud.transportable.run.constraints.requirements.AbstractRequirements;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;

@Immutable
public class MinimalRequirements
extends AbstractRequirements {
    private static final long serialVersionUID = 7206844309205691137L;
    private static final MinimalRequirements INSTANCE = new MinimalRequirements();

    private MinimalRequirements() {
    }

    public static MinimalRequirements getInstance() {
        return INSTANCE;
    }

    @Override
    public Optional<MemoryUnit> getMemoryRequirements() {
        return Optional.absent();
    }

    @Override
    public int getProcessorRequirements() {
        return 1;
    }

    @Override
    public List<String> getCPURequirements() {
        return ImmutableList.of();
    }

    @Override
    public boolean requireCgroups() {
        return false;
    }

    @Override
    public boolean isSatisfiedBy(MemoryUnit availableMemory, Map<Integer, MemoryUnit> freeNumaMemory, Set<Processor> usableProcessors, int maxUsableCoresPerSoket, HostInformation hostInformation) {
        Preconditions.checkNotNull(availableMemory);
        Preconditions.checkNotNull(freeNumaMemory);
        Preconditions.checkNotNull(usableProcessors);
        Preconditions.checkNotNull(hostInformation);
        Preconditions.checkArgument(maxUsableCoresPerSoket >= 0);
        return usableProcessors.size() > 0;
    }

    private Object readResolve() {
        return INSTANCE;
    }
}

