/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.transportable.run.constraints.requirements;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sosy_lab.verifiercloud.transportable.run.constraints.requirements.DefaultRequirements;
import org.sosy_lab.verifiercloud.transportable.run.constraints.requirements.Requirements;
import org.sosy_lab.verifiercloud.transportable.units.memory.MemoryUnit;

public class RequirementsBuilder {
    private final int processorRequirement;
    private Optional<MemoryUnit> memoryRequirement = Optional.absent();
    private List<String> cpuRequirements = ImmutableList.of();
    private boolean requiresCgroups = false;

    private RequirementsBuilder(int processorRequirement) {
        Preconditions.checkArgument(processorRequirement >= 1);
        this.processorRequirement = processorRequirement;
    }

    public static RequirementsBuilder withProcessors(int processorRequirements) {
        return new RequirementsBuilder(processorRequirements);
    }

    public RequirementsBuilder setMemoryRequirements(MemoryUnit memoryRequirements) {
        this.memoryRequirement = Optional.of(memoryRequirements);
        return this;
    }

    public RequirementsBuilder setCpuRequirements(String cpuRequirement) {
        this.cpuRequirements = ImmutableList.of(cpuRequirement);
        return this;
    }

    public RequirementsBuilder setCpuRequirements(List<String> cpuRequirements) {
        this.cpuRequirements = ImmutableList.copyOf(cpuRequirements);
        return this;
    }

    public RequirementsBuilder requireCgroups() {
        this.requiresCgroups = true;
        return this;
    }

    public Requirements build() {
        return new DefaultRequirements(this.memoryRequirement, this.processorRequirement, this.cpuRequirements, this.requiresCgroups);
    }
}

