/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.transportable.run.filters;

import java.nio.file.Path;
import javax.annotation.concurrent.Immutable;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.FileAtRelativePath;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.RelativePath;
import org.sosy_lab.verifiercloud.transportable.run.filters.FileFilter;

@Immutable
public class CompletePathFileFilter
implements FileFilter {
    private static final long serialVersionUID = -2710276782371697956L;
    final String path;

    public CompletePathFileFilter(String path) {
        this.path = path;
    }

    public CompletePathFileFilter(Path path) {
        this.path = path.toString();
    }

    public CompletePathFileFilter(RelativePath workerResultFile) {
        this.path = workerResultFile.getRelativePath();
    }

    @Override
    public boolean isFileMatched(FileAtRelativePath file) {
        return file.getRelativePathString().equals(this.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CompletePathFileFilter)) {
            return false;
        }
        CompletePathFileFilter that = (CompletePathFileFilter)other;
        return this.path.equals(that.path);
    }
}

