/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.verifiercloud.transportable.run.filters;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.sosy_lab.verifiercloud.transportable.file_hierarchy.FileAtRelativePath;
import org.sosy_lab.verifiercloud.transportable.run.filters.FileFilter;

@Immutable
public class ConjunctiveFileFilter
implements FileFilter {
    private static final long serialVersionUID = -6197151917447204734L;
    private final List<FileFilter> fileFilters;

    public ConjunctiveFileFilter(Collection<FileFilter> fileFilters) {
        Preconditions.checkNotNull(fileFilters);
        this.fileFilters = ImmutableList.copyOf(fileFilters);
    }

    @Override
    public boolean isFileMatched(FileAtRelativePath file) {
        for (FileFilter fileFilter : this.fileFilters) {
            if (fileFilter.isFileMatched(file)) continue;
            return false;
        }
        return true;
    }
}

